package foundry.veil.mixin.resource;

import foundry.veil.Veil;
import foundry.veil.ext.PackResourcesExtension;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_2960;
import net.minecraft.class_3264;
import net.minecraft.class_3268;
import net.minecraft.class_7367;

@Mixin(class_3268.class)
public abstract class VanillaPackResourcesMixin implements PackResourcesExtension {

    @Shadow
    @Final
    private Map<class_3264, List<Path>> pathsForType;

    @Shadow
    @Final
    private Set<String> namespaces;

    @Override
    public void veil$listResources(PackResourceConsumer consumer) {
        for (Map.Entry<class_3264, List<Path>> entry : this.pathsForType.entrySet()) {
            class_3264 type = entry.getKey();

            for (Path basePath : entry.getValue()) {
                String separator = basePath.getFileSystem().getSeparator();

                for (String namespace : this.namespaces) {
                    Path nsPath = basePath.resolve(namespace);

                    try {
                        Files.walkFileTree(nsPath, new SimpleFileVisitor<>() {
                            @Override
                            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) {
                                // Hack to make sure data pack isn't loaded as a resource pack
                                if (type == class_3264.field_14188 && dir.endsWith(class_3264.field_14190.method_14413())) {
                                    return FileVisitResult.SKIP_SUBTREE;
                                }
                                if (type == class_3264.field_14190 && dir.endsWith(class_3264.field_14188.method_14413())) {
                                    return FileVisitResult.SKIP_SUBTREE;
                                }
                                return FileVisitResult.CONTINUE;
                            }

                            @Override
                            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                                String filename = nsPath.relativize(file).toString().replace(separator, "/");
                                class_2960 name = class_2960.method_43902(namespace, filename);

                                if (name != null) {
                                    consumer.accept(type, name, nsPath, file, null);
                                }

                                return FileVisitResult.CONTINUE;
                            }

                            @Override
                            public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
                                if (file.endsWith("/data/realms")) { // This always fails, so just ignore it
                                    return FileVisitResult.CONTINUE;
                                }
                                return super.visitFileFailed(file, exc);
                            }
                        });
                    } catch (IOException e) {
                        Veil.LOGGER.warn("findResources in vanilla {} failed!", namespace, e);
                    }
                }
            }
        }
    }

    @Override
    public @Nullable class_7367<InputStream> veil$getIcon() {
        return null;
    }
}
