package foundry.veil.mixin.client.pipeline;

import com.mojang.blaze3d.systems.RenderSystem;
import foundry.veil.api.client.render.CameraMatrices;
import foundry.veil.api.client.render.CullFrustum;
import foundry.veil.api.client.render.VeilRenderBridge;
import foundry.veil.api.client.render.VeilRenderSystem;
import foundry.veil.ext.LevelRendererExtension;
import net.minecraft.class_1921;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4604;
import net.minecraft.class_761;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Vector3f;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(class_761.class)
public abstract class LevelRendererMixin implements LevelRendererExtension {

    @Shadow
    private class_4604 cullingFrustum;

    @Shadow
    @Nullable
    private class_4604 capturedFrustum;

    @Shadow
    protected abstract void renderChunkLayer(class_1921 p_172994_, class_4587 p_172995_, double p_172996_, double p_172997_, double p_172998_, Matrix4f p_254039_);

    @Unique
    private final Vector3f veil$tempCameraPos = new Vector3f();

    @Inject(method = "prepareCullFrustum", at = @At("HEAD"))
    public void veil$setupLevelCamera(class_4587 modelViewStack, class_243 pos, Matrix4f projection, CallbackInfo ci) {
        CameraMatrices matrices = VeilRenderSystem.renderer().getCameraMatrices();
        matrices.update(RenderSystem.getProjectionMatrix(), modelViewStack.method_23760().method_23761(), this.veil$tempCameraPos.set(pos.method_10216(), pos.method_10214(), pos.method_10215()), 0.05F, class_310.method_1551().field_1773.method_32796());
    }

    @Override
    public CullFrustum veil$getCullFrustum() {
        return VeilRenderBridge.create(this.capturedFrustum != null ? this.capturedFrustum : this.cullingFrustum);
    }

    @Override
    public void veil$drawBlockLayer(class_1921 renderType, class_4587 poseStack, double x, double y, double z, Matrix4f projection) {
        this.renderChunkLayer(renderType, poseStack, x, y, z, projection);
    }
}