package foundry.veil.mixin.client.shader;

import foundry.veil.impl.client.render.shader.ShaderProgramImpl;
import foundry.veil.impl.client.render.shader.SimpleShaderProcessor;
import foundry.veil.impl.client.render.wrapper.VanillaUniformWrapper;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_281;
import net.minecraft.class_284;
import net.minecraft.class_5912;
import net.minecraft.class_5944;

import static org.lwjgl.opengl.GL20C.glGetUniformLocation;

@Mixin(class_5944.class)
public class ShaderInstanceMixin {

    @Shadow
    @Final
    private int programId;
    @Shadow
    @Final
    private List<Integer> uniformLocations;
    @Shadow
    @Final
    public Map<String, class_284> uniformMap;

    @Unique
    private final Set<String> veil$invalidUniforms = new HashSet<>();

    @Inject(method = "getOrCreate", at = @At("HEAD"), cancellable = true)
    private static void veil$cancelDummyProgram(class_5912 provider, class_281.class_282 type, String name, CallbackInfoReturnable<class_281> cir) {
        if (ShaderProgramImpl.Wrapper.constructing) {
            cir.setReturnValue(null);
        }
    }

    @Inject(method = "getOrCreate", at = @At("HEAD"))
    private static void veil$setupFallbackProcessor(class_5912 provider, class_281.class_282 type, String name, CallbackInfoReturnable<class_281> cir) {
        SimpleShaderProcessor.setup(provider);
    }

    @Inject(method = "getOrCreate", at = @At("RETURN"))
    private static void veil$clearFallbackProcessor(class_5912 provider, class_281.class_282 type, String name, CallbackInfoReturnable<class_281> cir) {
        SimpleShaderProcessor.free();
    }

    // Allows users to request uniforms that aren't "registered"
    @Inject(method = "getUniform", at = @At("RETURN"), cancellable = true)
    public void getUniform(String name, CallbackInfoReturnable<class_284> cir) {
        if (cir.getReturnValue() == null && !this.veil$invalidUniforms.contains(name)) {
            int location = glGetUniformLocation(this.programId, name);
            if (location == -1) {
                this.veil$invalidUniforms.add(name);
                return;
            }

            class_284 uniform = new VanillaUniformWrapper(this.programId, name);
            this.uniformLocations.add(location);
            uniform.method_1297(location);
            this.uniformMap.put(name, uniform);
            cir.setReturnValue(uniform);
        }
    }

    @Inject(method = "updateLocations", at = @At("TAIL"))
    public void updateLocations(CallbackInfo ci) {
        this.veil$invalidUniforms.clear();
    }
}
