package foundry.veil.api.client.render.rendertype.layer;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import foundry.veil.api.client.registry.RenderTypeLayerRegistry;
import foundry.veil.api.client.render.rendertype.VeilRenderTypeBuilder;
import net.minecraft.class_310;
import net.minecraft.class_4668;

public record VanillaShaderLayer(String shaderName) implements RenderTypeLayer {

    public static final Codec<VanillaShaderLayer> CODEC = RecordCodecBuilder.create(instance -> instance.group(
            Codec.STRING.comapFlatMap(name -> class_310.method_1551().field_1773.method_35767(name) != null ? DataResult.success(name) : DataResult.error(() -> "Unknown Vanilla Shader: " + name), s -> s)
                    .fieldOf("name")
                    .forGetter(VanillaShaderLayer::shaderName)
    ).apply(instance, VanillaShaderLayer::new));

    @Override
    public void addLayer(VeilRenderTypeBuilder builder) {
        builder.shaderState(new class_4668.class_5942(() -> class_310.method_1551().field_1773.method_35767(this.shaderName)));
    }

    @Override
    public RenderTypeLayerRegistry.LayerType<?> getType() {
        return RenderTypeLayerRegistry.VANILLA_SHADER.get();
    }
}
