package foundry.veil.api.client.render.rendertype;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.*;
import foundry.veil.Veil;
import foundry.veil.api.client.render.VeilRenderBridge;
import foundry.veil.api.client.render.VeilVertexFormat;
import foundry.veil.api.client.render.shader.VeilShaders;
import foundry.veil.mixin.accessor.RenderTypeAccessor;
import java.util.Arrays;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.minecraft.class_156;
import net.minecraft.class_1921;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_4668;
import net.minecraft.class_5944;
import net.minecraft.class_8251;

/**
 * Custom Veil-implemented render types.
 */
public final class VeilRenderType extends class_1921 {

    private static final class_5942 PARTICLE = VeilRenderBridge.shaderState(VeilShaders.PARTICLE);
    private static final class_5942 PARTICLE_ADD = VeilRenderBridge.shaderState(VeilShaders.PARTICLE_ADD);

    private static final class_5942 SKINNED_MESH = VeilRenderBridge.shaderState(VeilShaders.SKINNED_MESH);

    private static final BiFunction<class_2960, Boolean, class_1921> QUASAR_PARTICLE = class_156.method_34865((texture, additive) -> {
        class_4688 state = class_1921.class_4688.method_23598()
                .method_34578(additive ? PARTICLE_ADD : PARTICLE)
                .method_34577(new class_4683(texture, false, false))
                .method_23615(additive ? field_21366 : field_21370)
                .method_23608(field_21383)
                .method_23616(additive ? field_21350 : field_21349)
                .method_23617(false);
        return method_24049(Veil.MODID + ":quasar_particle", class_290.field_1584, class_293.class_5596.field_27382, field_32774, false, !additive, state);
    });
    private static final Function<class_2960, class_1921> QUASAR_TRAIL = class_156.method_34866((texture) -> {
        class_4688 state = class_4688.method_23598()
                .method_34578(field_38344)
                .method_34577(new class_4683(texture, false, false))
                .method_23615(field_21366)
                .method_23616(field_21350)
                .method_23603(field_21345)
                .method_23617(false);
        return class_1921.method_24049(Veil.MODID + ":quasar_trail", class_290.field_1580, class_293.class_5596.field_27380, field_32775, false, false, state);
    });

    private static final Function<class_2960, class_1921> NECROMANCER_SKINNED_MESH = class_156.method_34866((texture) -> {
        class_4688 state = class_1921.class_4688.method_23598()
                .method_34578(SKINNED_MESH)
                .method_34577(new class_4668.class_4683(texture, false, false))
                .method_23615(field_21364)
                .method_23608(field_21383)
                .method_23611(field_21385)
                .method_23617(true);
        return class_1921.method_24049(Veil.MODID + ":skinned_mesh", VeilVertexFormat.SKINNED_MESH, class_293.class_5596.field_27382, field_32774, true, false, state);
    });


    public static class_1921 quasarParticle(class_2960 texture, boolean additive) {
        return QUASAR_PARTICLE.apply(texture, additive);
    }

    public static class_1921 quasarTrail(class_2960 texture) {
        return QUASAR_TRAIL.apply(texture);
    }

    /**
     * Creates a render type that uses a single draw buffer, but re-uses the data to draw the specified layers.
     *
     * @param layers The layers to use
     * @return A render type that draws all layers from a single buffer
     * @throws IllegalStateException If there are zero layers, the vertex formats don't all match, or the primitive modes don't match
     */
    public static class_1921 layered(class_1921... layers) {
        if (layers.length == 0) {
            throw new IllegalArgumentException("At least 1 render type must be specified");
        }
        if (layers.length == 1) {
            return layers[0];
        }
        ImmutableList.Builder<class_1921> builder = ImmutableList.builder();
        class_293 format = layers[0].method_23031();
        class_293.class_5596 mode = layers[0].method_23033();
        int bufferSize = layers[0].method_22722();
        boolean sortOnUpload = ((RenderTypeAccessor) layers[0]).isSortOnUpload();
        for (int i = 1; i < layers.length; i++) {
            class_1921 layer = layers[i];
            if (!layer.method_23031().equals(format)) {
                throw new IllegalArgumentException("Expected " + layer + " to use " + format + ", but was " + layer.method_23031());
            }
            if (!layer.method_23033().equals(mode)) {
                throw new IllegalArgumentException("Expected " + layer + " to use " + mode + ", but was " + layer.method_23033());
            }
            bufferSize = Math.max(bufferSize, layer.method_22722());
            if (((RenderTypeAccessor) layer).isSortOnUpload()) {
                sortOnUpload = true;
            }
            builder.add(layer);
        }
        return new LayeredRenderType(layers[0], builder.build(), "LayeredRenderType[" + Arrays.stream(layers).map(class_1921::toString) + "]", bufferSize, sortOnUpload);
    }

    private VeilRenderType(String $$0, class_293 $$1, class_293.class_5596 $$2, int $$3, boolean $$4, boolean $$5, Runnable $$6, Runnable $$7) {
        super($$0, $$1, $$2, $$3, $$4, $$5, $$6, $$7);
    }

    public static class LayeredRenderType extends class_1921 {

        private final List<class_1921> layers;

        private LayeredRenderType(class_1921 defaultValue, List<class_1921> layers, String name, int bufferSize, boolean sortOnUpload) {
            super(name, defaultValue.method_23031(), defaultValue.method_23033(), bufferSize, defaultValue.method_23037(), sortOnUpload, defaultValue::method_23516, defaultValue::method_23518);
            this.layers = layers;
        }

        @Override
        public void method_23012(class_287 builder, class_8251 sorting) {
            class_286.method_43436();
            super.method_23012(builder, sorting);
            if (class_286.field_38982 != null) {
                for (class_1921 layer : this.layers) {
                    layer.method_23516();
                    class_5944 shader = RenderSystem.getShader();
                    shader.method_34586();
                    class_286.field_38982.method_35665();
                    shader.method_34585();
                    layer.method_23518();
                }
            }
        }
    }
}
