package foundry.veil.api.client.registry;

import foundry.veil.api.client.pose.ExtendedPose;
import foundry.veil.api.client.pose.PoseData;
import foundry.veil.api.client.util.Easings;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.class_1753;
import net.minecraft.class_1764;
import net.minecraft.class_1792;
import net.minecraft.class_1835;
import net.minecraft.class_310;
import net.minecraft.class_572;
import net.minecraft.class_630;

public class PoseRegistry {
    public static Map<Predicate<class_1792>, ExtendedPose> poses = new HashMap<>();

    /**
     * Add a {@link ExtendedPose} to the registry.
     *
     * @param item The item that triggers the pose.
     * @param pose The pose.
     *             <p>
     *             Create an {@link ExtendedPose}, either using an anonymous class or a separate class.
     *             You are given a {@link PoseData} object which contains various state data of the model.
     **/
    public static ExtendedPose registerPose(class_1792 item, ExtendedPose pose) {
        poses.put(i -> i.equals(item), pose);
        return pose;
    }

    /**
     * Add a {@link ExtendedPose} to the registry.
     *
     * @param itemPredicate A predicate that determines if the pose should be applied to the item.
     * @param pose          The pose.
     *                      <p>
     *                      Create an {@link ExtendedPose}, either using an anonymous class or a separate class.
     *                      You are given a {@link PoseData} object which contains various state data of the model.
     */
    public static ExtendedPose registerPose(Predicate<class_1792> itemPredicate, ExtendedPose pose) {
        poses.put(itemPredicate, pose);
        return pose;
    }

    /**
     * An example pose registered by Veil. This pose is applied when the player is using a bow. It slowly raises the arms as the bow is drawn.
     */
    public static ExtendedPose BOW = registerPose(item -> item instanceof class_1753, new ExtendedPose() {
        @Override
        public void poseMainHand(class_630 mainHand) {
            float mult = Math.min(data.useTime + data.partialTick, data.maxUseTime) / data.maxUseTime;
            mult = Easings.ease(mult, Easings.Easing.easeInOutSine);
            mainHand.field_3654 *= mult;
        }

        @Override
        public void poseOffHand(class_630 offHand) {
            float mult = Math.min(data.useTime + data.partialTick, data.maxUseTime) / data.maxUseTime;
            mult = Easings.ease(mult, Easings.Easing.easeInOutSine);
            offHand.field_3654 *= mult;
        }
    });

    public static ExtendedPose CROSSBOW = registerPose(i -> i instanceof class_1764, new ExtendedPose() {
        @Override
        public void poseMainHand(class_630 mainHand) {
            float mult = Math.min(data.useTime + data.partialTick, data.maxUseTime) / data.maxUseTime;
            mult = Easings.ease(mult, Easings.Easing.easeInOutSine);
            mainHand.field_3654 *= mult;
        }

        @Override
        public void poseOffHand(class_630 offHand) {
            float mult = Math.min(data.useTime + data.partialTick, data.maxUseTime) / data.maxUseTime;
            mult = Easings.ease(mult, Easings.Easing.easeInOutSine);
            offHand.field_3654 *= mult;
        }
    });

//    public static ExtendedPose SHIELD = registerPose(i -> i instanceof ShieldItem, new ExtendedPose() {
//        float headXRot = 0;
//        float headYRot = 0;
//
//        @Override
//        public void pose(HumanoidModel<?> model) {
//            super.pose(model);
//            headXRot = model.head.xRot;
//            headYRot = model.head.yRot;
//        }
//
//        @Override
//        public void poseItem(ItemInHandRenderer itemRenderer) {
//            data.stackPoseStack.translate(0,0.25,0);
//        }
//
//        @Override
//        public void poseMainHand(ModelPart offHand) {
//            if (!data.swapped) {
//                offHand.xRot = -((float) Math.PI / 4F) + headXRot / 3f;
//                offHand.yRot = ((float) -Math.PI / 8F) + headYRot / 3f;
//                float mult = Math.min(data.useTime + data.partialTick, data.maxUseTime) / data.maxUseTime;
//                mult = Easings.ease(mult, Easings.Easing.easeInOutSine);
//                offHand.xRot *= mult * 1.2f;
//                offHand.yRot *= mult * 1.75f;
//            }
//        }
//
//        @Override
//        public void poseOffHand(ModelPart offHand) {
//            if (data.swapped) {
//                offHand.xRot = -((float) Math.PI / 4F) + headXRot / 3f;
//                offHand.yRot = -((float) -Math.PI / 8F) + headYRot / 3f;
//                float mult = Math.min(data.useTime + data.partialTick, data.maxUseTime) / data.maxUseTime;
//                mult = Easings.ease(mult, Easings.Easing.easeInOutSine);
//                offHand.xRot *= mult * 1.2f;
//                offHand.yRot *= mult * 1.75f;
//            }
//        }
//    });

    /**
     * An example pose registered by Veil. This pose is applied when the player is using a trident. It captures some model data and uses it to pose the body.
     */
    public static ExtendedPose TRIDENT = registerPose(i -> i instanceof class_1835, new ExtendedPose() {
        float headXRot = 0;
        float headYRot = 0;
        public final boolean forceRenderOffhand = true;

        @Override
        public void pose(class_572<?> model) {
            super.pose(model);
            headXRot = model.field_3398.field_3654;
            headYRot = model.field_3398.field_3675;
        }

        @Override
        public void poseBody(class_630 body) {
            body.field_3654 = -0.75f + Math.max(0, (((float) Math.PI / 2F) + headXRot)) / 2f;
        }

        @Override
        public void poseMainHand(class_630 mainHand) {
            if (data.swapped) {
                mainHand.field_3675 = 0.1F + headYRot;
                mainHand.field_3654 = -((float) Math.PI / 2F) + headXRot;
                float mult = Math.min(data.useTime + data.partialTick, data.maxUseTime) / data.maxUseTime;
                mult = Easings.ease(mult, Easings.Easing.easeInOutSine);
                mainHand.field_3654 *= mult;
                mainHand.field_3675 *= mult;
            } else {
                mainHand.field_3654 = (-(float) Math.PI / 2F) + headXRot - 1.5f;
                float mult = Math.min(data.useTime + data.partialTick, data.maxUseTime) / data.maxUseTime;
                mult = Easings.ease(mult, Easings.Easing.easeInOutSine);
                if (!class_310.method_1551().field_1724.method_5715()) {
                    mainHand.field_3654 *= mult;
                    return;
                }
                mainHand.field_3654 *= mult / 2f;
                mainHand.field_3675 = 1.25f + headYRot;
                //mainHand.yRot *= ;
                if (data.useTime >= data.maxUseTime) {
                    mainHand.field_3675 += (float) (Math.sin((data.useTime + data.partialTick) / 2f) * 0.5f);
                    mainHand.field_3654 += (float) (Math.cos((data.useTime + data.partialTick) / 2f) * 0.5f);
                }
            }
        }

        @Override
        public void poseOffHand(class_630 offHand) {
            if (data.swapped) {
                offHand.field_3654 = (-(float) Math.PI / 2F) + headXRot - 1.5f;
                float mult = Math.min(data.useTime + data.partialTick, data.maxUseTime) / data.maxUseTime;
                mult = Easings.ease(mult, Easings.Easing.easeInOutSine);
                if (!class_310.method_1551().field_1724.method_5715()) {
                    offHand.field_3654 *= mult;
                    return;
                }
                offHand.field_3654 *= mult / 2f;
                offHand.field_3675 = 1.25f + headYRot;
                //mainHand.yRot *= ;
                if (data.useTime >= data.maxUseTime) {
                    offHand.field_3675 += (float) (Math.sin((data.useTime + data.partialTick) / 2f) * 0.5f);
                    offHand.field_3654 += (float) (Math.cos((data.useTime + data.partialTick) / 2f) * 0.5f);
                }
            } else {
                offHand.field_3675 = 0.1F + headYRot;
                offHand.field_3654 = -((float) Math.PI / 2F) + headXRot;
                float mult = Math.min(data.useTime + data.partialTick, data.maxUseTime) / data.maxUseTime;
                mult = Easings.ease(mult, Easings.Easing.easeInOutSine);
                offHand.field_3654 *= mult;
                offHand.field_3675 *= mult;
            }
        }
    });
}
