package foundry.veil.impl.resource.loader;

import foundry.veil.api.resource.VeilResource;
import foundry.veil.api.resource.VeilResourceInfo;
import foundry.veil.api.resource.VeilResourceLoader;
import foundry.veil.api.resource.VeilResourceManager;
import foundry.veil.api.resource.type.PostPipelineResource;
import org.jetbrains.annotations.Nullable;

import java.io.IOException;
import java.nio.file.Path;
import net.minecraft.class_2960;
import net.minecraft.class_3264;
import net.minecraft.class_5912;

public class PostPipelineResourceLoader implements VeilResourceLoader {

    @Override
    public boolean canLoad(class_3264 packType, class_2960 location, @Nullable Path filePath, @Nullable Path modResourcePath) {
        String path = location.method_12832();
        return path.startsWith("pinwheel/post") && path.endsWith(".json");
    }

    @Override
    public VeilResource<?> load(VeilResourceManager resourceManager, class_5912 provider, class_3264 packType, class_2960 location, @Nullable Path filePath, @Nullable Path modResourcePath) throws IOException {
        return new PostPipelineResource(new VeilResourceInfo(packType, location, filePath, modResourcePath, false));
    }
}
