package foundry.veil.impl.client.render.wrapper;

import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.joml.Vector3f;
import org.joml.Vector4f;
import org.lwjgl.system.MemoryStack;

import java.nio.FloatBuffer;
import java.util.Arrays;
import net.minecraft.class_284;

import static org.lwjgl.opengl.GL41C.*;

@ApiStatus.Internal
public class VanillaUniformWrapper extends class_284 {

    private final int programId;
    private int location;

    public VanillaUniformWrapper(int shaderId, String name) {
        super(name, field_32038, 0, null);
        this.close(); // Free constructor allocated resources
        this.programId = shaderId;
        this.location = -1;
    }

    @Override
    public void method_1297(int location) {
        this.location = location;
    }

    @Override
    public void method_35659(int index, float value) {
        throw new UnsupportedOperationException("Use absolute set");
    }

    @Override
    public void method_1251(float value) {
        if (this.location != -1) {
            glProgramUniform1f(this.programId, this.location, value);
        }
    }

    @Override
    public void method_1255(float x, float y) {
        if (this.location != -1) {
            glProgramUniform2f(this.programId, this.location, x, y);
        }
    }

    @Override
    public void method_1249(float x, float y, float z) {
        if (this.location != -1) {
            glProgramUniform3f(this.programId, this.location, x, y, z);
        }
    }

    @Override
    public void method_1254(float x, float y, float z, float w) {
        if (this.location != -1) {
            glProgramUniform4f(this.programId, this.location, x, y, z, w);
        }
    }

    @Override
    public void method_34413(@NotNull Vector3f value) {
        this.method_1249(value.x, value.y, value.z);
    }

    @Override
    public void method_35652(@NotNull Vector4f value) {
        this.method_1254(value.x, value.y, value.z, value.w);
    }

    @Override
    public void method_1252(float x, float y, float z, float w) {
        this.method_1254(x, y, z, w);
    }

    @Override
    public void method_35649(int value) {
        if (this.location != -1) {
            glProgramUniform1i(this.programId, this.location, value);
        }
    }

    @Override
    public void method_35650(int x, int y) {
        if (this.location != -1) {
            glProgramUniform2i(this.programId, this.location, x, y);
        }
    }

    @Override
    public void method_35651(int x, int y, int z) {
        if (this.location != -1) {
            glProgramUniform3i(this.programId, this.location, x, y, z);
        }
    }

    @Override
    public void method_35656(int x, int y, int z, int w) {
        if (this.location != -1) {
            glProgramUniform4i(this.programId, this.location, x, y, z, w);
        }
    }

    @Override
    public void method_1248(int x, int y, int z, int w) {
        this.method_35656(x, y, z, w);
    }

    @Override
    public void method_1253(float[] values) {
        switch (values.length) {
            case 1 -> this.method_1251(values[0]);
            case 2 -> this.method_1255(values[0], values[1]);
            case 3 -> this.method_1249(values[0], values[1], values[2]);
            case 4 -> this.method_1254(values[0], values[1], values[2], values[3]);
            default -> throw new UnsupportedOperationException("Invalid value array: " + Arrays.toString(values));
        }
    }

    @Override
    public void method_35657(float $$0, float $$1, float $$2, float $$3) {
        throw new UnsupportedOperationException("Use #set(Matrix4fc) or #set(Matrix3fc) instead");
    }

    @Override
    public void method_35644(float $$0, float $$1, float $$2, float $$3, float $$4, float $$5) {
        throw new UnsupportedOperationException("Use #set(Matrix4fc) or #set(Matrix3fc) instead");
    }

    @Override
    public void method_35645(float $$0, float $$1, float $$2, float $$3, float $$4, float $$5, float $$6, float $$7) {
        throw new UnsupportedOperationException("Use #set(Matrix4fc) or #set(Matrix3fc) instead");
    }

    @Override
    public void method_35653(float $$0, float $$1, float $$2, float $$3, float $$4, float $$5) {
        throw new UnsupportedOperationException("Use #set(Matrix4fc) or #set(Matrix3fc) instead");
    }

    @Override
    public void method_35646(float $$0, float $$1, float $$2, float $$3, float $$4, float $$5, float $$6, float $$7,
                          float $$8) {
        throw new UnsupportedOperationException("Use #set(Matrix4fc) or #set(Matrix3fc) instead");
    }

    @Override
    public void method_35647(float $$0, float $$1, float $$2, float $$3, float $$4, float $$5, float $$6, float $$7,
                          float $$8, float $$9, float $$10, float $$11) {
        throw new UnsupportedOperationException("Use #set(Matrix4fc) or #set(Matrix3fc) instead");
    }

    @Override
    public void method_35654(float $$0, float $$1, float $$2, float $$3, float $$4, float $$5, float $$6, float $$7) {
        throw new UnsupportedOperationException("Use #set(Matrix4fc) or #set(Matrix3fc) instead");
    }

    @Override
    public void method_35655(float $$0, float $$1, float $$2, float $$3, float $$4, float $$5, float $$6, float $$7,
                          float $$8, float $$9, float $$10, float $$11) {
        throw new UnsupportedOperationException("Use #set(Matrix4fc) or #set(Matrix3fc) instead");
    }

    @Override
    public void method_35648(float $$0, float $$1, float $$2, float $$3, float $$4, float $$5, float $$6, float $$7,
                          float $$8, float $$9, float $$10, float $$11, float $$12, float $$13, float $$14,
                          float $$15) {
        throw new UnsupportedOperationException("Use #set(Matrix4fc) or #set(Matrix3fc) instead");
    }

    @Override
    public void method_39978(@NotNull Matrix3f value) {
        if (this.location == -1) {
            return;
        }

        try (MemoryStack stack = MemoryStack.stackPush()) {
            FloatBuffer buffer = stack.mallocFloat(3 * 3);
            value.get(buffer);
            glProgramUniformMatrix3fv(this.programId, this.location, false, buffer);
        }
    }

    @Override
    public void method_1250(@NotNull Matrix4f value) {
        if (this.location == -1) {
            return;
        }

        try (MemoryStack stack = MemoryStack.stackPush()) {
            FloatBuffer buffer = stack.mallocFloat(4 * 4);
            value.get(buffer);
            glProgramUniformMatrix4fv(this.programId, this.location, false, buffer);
        }
    }

    @Override
    public void method_1300() {
    }

    @Override
    public int method_35660() {
        return this.location;
    }
}
