package foundry.veil.api.client.util;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.Object2IntArrayMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.Locale;
import java.util.Map;
import net.minecraft.class_1921;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_296;

public class VertexFormatCodec {

    private static final Map<String, class_296> DEFAULT_ELEMENTS = Map.of(
            "POSITION", class_290.field_1587,
            "COLOR", class_290.field_1581,
            "UV0", class_290.field_1591,
            "UV1", class_290.field_1583,
            "UV2", class_290.field_20886,
            "NORMAL", class_290.field_1579,
            "PADDING", class_290.field_1578,
            "UV", class_290.field_29335);
    private static final Map<String, class_293> DEFAULT_FORMATS = Map.ofEntries(
            Map.entry("BLIT_SCREEN", class_290.field_29336),
            Map.entry("BLOCK", class_290.field_1590),
            Map.entry("NEW_ENTITY", class_290.field_1580),
            Map.entry("PARTICLE", class_290.field_1584),
            Map.entry("POSITION", class_290.field_1592),
            Map.entry("POSITION_COLOR", class_290.field_1576),
            Map.entry("POSITION_COLOR_NORMAL", class_290.field_29337),
            Map.entry("POSITION_COLOR_LIGHTMAP", class_290.field_21468),
            Map.entry("POSITION_TEX", class_290.field_1585),
            Map.entry("POSITION_COLOR_TEX", class_290.field_20887),
            Map.entry("POSITION_TEX_COLOR", class_290.field_1575),
            Map.entry("POSITION_COLOR_TEX_LIGHTMAP", class_290.field_20888),
            Map.entry("POSITION_TEX_LIGHTMAP_COLOR", class_290.field_1586),
            Map.entry("POSITION_TEX_COLOR_NORMAL", class_290.field_1577));
    private static final Object2IntMap<String> DEFAULT_BUFFER_SIZES = new Object2IntArrayMap<>(Map.of(
            "BIG", class_1921.field_32772,
            "MEDIUM", class_1921.field_32773,
            "SMALL", class_1921.field_32774,
            "TRANSIENT", class_1921.field_32775));

    private static final Codec<class_296.class_297> ELEMENT_TYPE_CODEC = Codec.STRING.flatXmap(name -> {
        for (class_296.class_297 type : class_296.class_297.values()) {
            if (type.name().equalsIgnoreCase(name)) {
                return DataResult.success(type);
            }
        }
        return DataResult.error(() -> "Unknown element type: " + name.toLowerCase(Locale.ROOT));
    }, type -> DataResult.success(type.name().toLowerCase(Locale.ROOT)));
    private static final Codec<class_296.class_298> ELEMENT_USAGE_CODEC = Codec.STRING.flatXmap(name -> {
        for (class_296.class_298 usage : class_296.class_298.values()) {
            if (usage.name().equalsIgnoreCase(name)) {
                return DataResult.success(usage);
            }
        }
        return DataResult.error(() -> "Unknown mode: " + name.toLowerCase(Locale.ROOT));
    }, usage -> DataResult.success(usage.name().toLowerCase(Locale.ROOT)));
    public static final Codec<class_293.class_5596> MODE_CODEC = Codec.STRING.flatXmap(name -> {
        for (class_293.class_5596 mode : class_293.class_5596.values()) {
            if (mode.name().equalsIgnoreCase(name)) {
                return DataResult.success(mode);
            }
        }
        return DataResult.error(() -> "Unknown mode: " + name.toLowerCase(Locale.ROOT));
    }, mode -> DataResult.success(mode.name().toLowerCase(Locale.ROOT)));

    private static final Codec<class_296> DEFAULT_ELEMENT_CODEC = Codec.STRING.flatXmap(name -> {
        String key = name.toUpperCase(Locale.ROOT);
        class_296 element = DEFAULT_ELEMENTS.get(key);
        return element != null ? DataResult.success(element) : DataResult.error(() -> "Unknown default element: " + key);
    }, element -> {
        for (Map.Entry<String, class_296> entry : DEFAULT_ELEMENTS.entrySet()) {
            if (element.equals(entry.getValue())) {
                return DataResult.success(entry.getKey());
            }
        }
        return DataResult.error(() -> "Unknown default element for: " + element);
    });
    private static final Codec<class_296> FULL_ELEMENT_CODEC = RecordCodecBuilder.create(instance -> instance.group(
            Codec.INT.fieldOf("index").forGetter(class_296::method_1385),
            ELEMENT_TYPE_CODEC.fieldOf("type").forGetter(class_296::method_1386),
            ELEMENT_USAGE_CODEC.fieldOf("usage").forGetter(class_296::method_1382),
            Codec.intRange(0, Integer.MAX_VALUE).fieldOf("count").forGetter(class_296::method_34451)
    ).apply(instance, class_296::new));

    public static final Codec<class_296> ELEMENT_CODEC = Codec.either(DEFAULT_ELEMENT_CODEC, FULL_ELEMENT_CODEC).xmap(either -> either.map(a -> a, a -> a), element -> {
        for (Map.Entry<String, class_296> entry : DEFAULT_ELEMENTS.entrySet()) {
            if (element.equals(entry.getValue())) {
                return Either.left(element);
            }
        }
        return Either.right(element);
    });

    private static final Codec<class_293> DEFAULT_CODEC = Codec.STRING.flatXmap(name -> {
        String key = name.toUpperCase(Locale.ROOT);
        class_293 format = DEFAULT_FORMATS.get(key);
        return format != null ? DataResult.success(format) : DataResult.error(() -> "Unknown default vertex format: " + key);
    }, format -> {
        for (Map.Entry<String, class_293> entry : DEFAULT_FORMATS.entrySet()) {
            if (format.equals(entry.getValue())) {
                return DataResult.success(entry.getKey());
            }
        }
        return DataResult.error(() -> "Unknown default vertex format for: " + format);
    });
    @SuppressWarnings("UnstableApiUsage")
    private static final Codec<class_293> FULL_CODEC = Codec.unboundedMap(Codec.STRING, ELEMENT_CODEC).xmap(map -> new class_293(ImmutableMap.copyOf(map)), format -> {
        ImmutableList<String> keys = format.method_34445();
        ImmutableList<class_296> values = format.method_1357();
        ImmutableMap.Builder<String, class_296> map = ImmutableMap.builderWithExpectedSize(keys.size());
        for (int i = 0; i < keys.size(); i++) {
            map.put(keys.get(i), values.get(i));
        }
        return map.build();
    });

    public static final Codec<class_293> CODEC = Codec.either(DEFAULT_CODEC, FULL_CODEC).xmap(either -> either.map(a -> a, a -> a), format -> {
        for (Map.Entry<String, class_293> entry : DEFAULT_FORMATS.entrySet()) {
            if (format.equals(entry.getValue())) {
                return Either.left(format);
            }
        }
        return Either.right(format);
    });

    private static final Codec<Integer> DEFAULT_SIZE_CODEC = Codec.STRING.flatXmap(name -> {
        String key = name.toUpperCase(Locale.ROOT);
        int format = DEFAULT_BUFFER_SIZES.getOrDefault(key, -1);
        return format != -1 ? DataResult.success(format) : DataResult.error(() -> "Unknown default buffer size: " + key);
    }, format -> {
        for (Object2IntMap.Entry<String> entry : DEFAULT_BUFFER_SIZES.object2IntEntrySet()) {
            if (format == entry.getIntValue()) {
                return DataResult.success(entry.getKey());
            }
        }
        return DataResult.error(() -> "Unknown default vertex format for: " + format);
    });

    public static final Codec<Integer> BUFFER_SIZE_CODEC = Codec.either(DEFAULT_SIZE_CODEC, Codec.intRange(0, Integer.MAX_VALUE)).xmap(either -> either.map(a -> a, a -> a), format -> {
        for (Object2IntMap.Entry<String> entry : DEFAULT_BUFFER_SIZES.object2IntEntrySet()) {
            if (format == entry.getIntValue()) {
                return Either.left(format);
            }
        }
        return Either.right(format);
    });
}
