/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.api.client.ui.util;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayDeque;
import java.util.Deque;
import net.minecraft.class_310;
import net.minecraft.class_3532;

public class ScissorStack {
    private final Deque<ScissorRegion> regions = new ArrayDeque<ScissorRegion>();

    public void push(int x, int y, int width, int height) {
        if (!this.regions.isEmpty()) {
            ScissorRegion parent = this.regions.peek();
            int x2 = x + width;
            x = class_3532.method_15340((int)x, (int)parent.x, (int)(parent.x + parent.width));
            width = class_3532.method_15340((int)x2, (int)parent.x, (int)(parent.x + parent.width)) - x;
            int y2 = y + height;
            y = class_3532.method_15340((int)y, (int)parent.y, (int)(parent.y + parent.height));
            height = class_3532.method_15340((int)y2, (int)parent.y, (int)(parent.y + parent.height)) - y;
        }
        ScissorRegion region = new ScissorRegion(x, y, width, height);
        this.regions.push(region);
        region.apply();
    }

    public void pop() {
        this.regions.pop();
        RenderSystem.disableScissor();
        if (!this.regions.isEmpty()) {
            this.regions.peek().apply();
        }
    }

    private static class ScissorRegion {
        int x;
        int y;
        int width;
        int height;

        public ScissorRegion(int x, int y, int width, int height) {
            this.x = x;
            this.y = y;
            this.width = width;
            this.height = height;
        }

        void apply() {
            double scale = class_310.method_1551().method_22683().method_4495();
            int screenY = (int)((double)(class_310.method_1551().method_22683().method_4506() - (this.y + this.height)) * scale);
            RenderSystem.enableScissor((int)((int)((double)this.x * scale)), (int)screenY, (int)((int)((double)this.width * scale)), (int)((int)((double)this.height * scale)));
        }
    }
}

