/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.api.client.editor;

import foundry.veil.Veil;
import foundry.veil.api.client.editor.EditorManager;
import foundry.veil.api.client.editor.ImGuiFontMetadataSectionSerializer;
import foundry.veil.api.client.render.VeilRenderer;
import foundry.veil.impl.client.imgui.VeilImGuiImpl;
import imgui.ImFont;
import imgui.ImFontAtlas;
import imgui.ImFontConfig;
import imgui.ImGui;
import java.io.IOException;
import java.io.InputStream;
import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.minecraft.class_2960;
import net.minecraft.class_3270;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3302;
import net.minecraft.class_3695;
import net.minecraft.class_7654;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.system.NativeResource;

@ApiStatus.Internal
public class EditorFontManager
implements class_3302 {
    private static final class_7654 FONT_LISTER = new class_7654("font", ".ttf");
    private static final DecimalFormat FONT_FORMAT = new DecimalFormat("0.#");
    private static final float FONT_SIZE = 20.0f;
    private final Map<class_2960, FontPackBuilder> fontBuilders = new HashMap<class_2960, FontPackBuilder>();
    private final Map<class_2960, FontPack> fonts = new HashMap<class_2960, FontPack>();
    private ImFont defaultFont;

    public ImFont getFont(class_2960 name, boolean bold, boolean italic) {
        FontPack font = this.fonts.get(name);
        if (font == null) {
            return this.defaultFont;
        }
        if (italic ^ bold) {
            return italic ? font.italic : font.bold;
        }
        return italic ? font.boldItalic : font.regular;
    }

    @NotNull
    public CompletableFuture<Void> method_25931(@NotNull class_3302.class_4045 preparationBarrier, @NotNull class_3300 resourceManager, @NotNull class_3695 prepareProfiler, @NotNull class_3695 applyProfiler, @NotNull Executor backgroundExecutor, @NotNull Executor gameExecutor) {
        if (!VeilRenderer.hasImGui()) {
            return preparationBarrier.method_18352(null);
        }
        return ((CompletableFuture)CompletableFuture.supplyAsync(() -> {
            HashMap<class_2960, FontData> fontData = new HashMap<class_2960, FontData>();
            for (Map.Entry entry : FONT_LISTER.method_45113(resourceManager).entrySet()) {
                class_2960 id = FONT_LISTER.method_45115((class_2960)entry.getKey());
                class_3298 resource = (class_3298)entry.getValue();
                try {
                    InputStream stream = resource.method_14482();
                    try {
                        short[] ranges = resource.method_14481().method_43041((class_3270)ImGuiFontMetadataSectionSerializer.INSTANCE).map(ImGuiFontMetadataSectionSerializer.FontMetadata::ranges).orElseGet(() -> new short[]{32, 255, 0});
                        fontData.put(id, new FontData(stream.readAllBytes(), ranges));
                    }
                    finally {
                        if (stream == null) continue;
                        stream.close();
                    }
                }
                catch (IOException e) {
                    Veil.LOGGER.error("Failed to load ImGui font: {}", (Object)id, (Object)e);
                }
            }
            return fontData;
        }, backgroundExecutor).thenCompose(arg_0 -> ((class_3302.class_4045)preparationBarrier).method_18352(arg_0))).thenAcceptAsync(fontData -> {
            this.fontBuilders.clear();
            block12: for (Map.Entry entry2 : fontData.entrySet()) {
                class_2960 id = (class_2960)entry2.getKey();
                String[] parts = id.method_12832().split("-", 2);
                if (parts.length < 2) continue;
                class_2960 name = new class_2960(id.method_12836(), parts[0]);
                String type = parts[1];
                FontPackBuilder builder = this.fontBuilders.computeIfAbsent(name, FontPackBuilder::new);
                switch (type) {
                    case "regular": {
                        builder.main = (FontData)entry2.getValue();
                        continue block12;
                    }
                    case "italic": {
                        builder.italic = (FontData)entry2.getValue();
                        continue block12;
                    }
                    case "bold": {
                        builder.bold = (FontData)entry2.getValue();
                        continue block12;
                    }
                    case "bold_italic": {
                        builder.boldItalic = (FontData)entry2.getValue();
                        continue block12;
                    }
                }
                Veil.LOGGER.warn("Unknown font type {} for font: {}", (Object)type, (Object)name);
            }
            this.fontBuilders.entrySet().removeIf(entry -> {
                if (entry.getValue() == null) {
                    Veil.LOGGER.warn("Skipping invalid font: {}", entry.getKey());
                    return true;
                }
                return false;
            });
            Veil.LOGGER.info("Loaded {} ImGui fonts", (Object)this.fontBuilders.size());
            this.rebuildFonts();
        }, gameExecutor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rebuildFonts() {
        try {
            Veil.beginImGui();
            ImFontAtlas atlas = ImGui.getIO().getFonts();
            atlas.clear();
            this.defaultFont = atlas.addFontDefault();
            this.fonts.clear();
            for (Map.Entry<class_2960, FontPackBuilder> entry : this.fontBuilders.entrySet()) {
                Veil.LOGGER.info("Built {}", (Object)entry.getKey());
                this.fonts.put(entry.getKey(), entry.getValue().build(20.0f));
            }
            ImGui.getIO().setFontDefault(this.getFont(EditorManager.DEFAULT_FONT, false, false));
            VeilImGuiImpl.get().updateFonts();
        }
        finally {
            Veil.endImGui();
        }
    }

    private record FontPack(ImFont regular, ImFont italic, ImFont bold, ImFont boldItalic) implements NativeResource
    {
        public void free() {
            this.regular.destroy();
            if (this.italic != this.regular) {
                this.italic.destroy();
            }
            if (this.bold != this.regular) {
                this.bold.destroy();
            }
            if (this.boldItalic != this.regular) {
                this.boldItalic.destroy();
            }
        }
    }

    private static class FontPackBuilder {
        private final class_2960 name;
        private FontData main;
        private FontData italic;
        private FontData bold;
        private FontData boldItalic;

        private FontPackBuilder(class_2960 name) {
            this.name = name;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private ImFont loadOrDefault(@Nullable FontData data, String type, float sizePixels, ImFont defaultFont) {
            if (data == null) {
                return defaultFont;
            }
            ImFontAtlas atlas = ImGui.getIO().getFonts();
            ImFontConfig fontConfig = new ImFontConfig();
            try {
                fontConfig.setName(this.name.method_12832() + " " + type + " " + FONT_FORMAT.format(sizePixels) + " px");
                fontConfig.setGlyphRanges(data.ranges);
                ImFont imFont = atlas.addFontFromMemoryTTF(data.bytes, sizePixels, fontConfig);
                return imFont;
            }
            finally {
                fontConfig.destroy();
            }
        }

        public FontPack build(float sizePixels) {
            ImFont main = Objects.requireNonNull(this.loadOrDefault(this.main, "regular", sizePixels, null));
            ImFont italic = this.loadOrDefault(this.italic, "italic", sizePixels, main);
            ImFont bold = this.loadOrDefault(this.bold, "bold", sizePixels, main);
            ImFont boldItalic = this.loadOrDefault(this.boldItalic, "bold_italic", sizePixels, main);
            return new FontPack(main, italic, bold, boldItalic);
        }
    }

    private record FontData(byte[] bytes, short[] ranges) {
    }
}

