package foundry.veil.platform.registry;

import java.util.function.Supplier;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6880;

/**
 * Represents a lazy wrapper for registry object.
 *
 * @param <T> the operand of the object
 */
public interface RegistryObject<T> extends Supplier<T> {

    /**
     * Gets the {@link class_5321} of the registry of the object wrapped.
     *
     * @return the {@link class_5321} of the registry
     */
    class_5321<T> getResourceKey();

    /**
     * Gets the id of the object.
     *
     * @return the id of the object
     */
    class_2960 getId();

    /**
     * @return If the initializer has been registered and assigned
     */
    boolean isPresent();

    /**
     * Gets the object behind this wrapper.
     *
     * @return the object behind this wrapper
     * @throws NullPointerException If {@link #isPresent()} returns <code>false</code>
     */
    @Override
    T get();

    /**
     * Gets this object wrapped in a vanilla {@link class_6880}.
     *
     * @return the holder
     */
    class_6880<T> asHolder();
}