package foundry.veil.impl.client.render;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.*;
import foundry.veil.api.client.color.Color;
import foundry.veil.api.client.color.theme.NumberThemeProperty;
import foundry.veil.api.client.tooltip.Tooltippable;
import foundry.veil.api.client.tooltip.VeilUIItemTooltipDataHolder;
import foundry.veil.api.client.util.SpaceHelper;
import foundry.veil.api.client.util.UIUtils;
import org.jetbrains.annotations.ApiStatus;
import org.joml.Matrix4f;
import org.joml.Vector3f;

import java.util.List;
import net.minecraft.class_1799;
import net.minecraft.class_1934;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_310;
import net.minecraft.class_329;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_4587;
import net.minecraft.class_5348;
import net.minecraft.class_757;

@ApiStatus.Internal
public class VeilUITooltipRenderer {

    public static int hoverTicks = 0;
    public static class_243 lastHoveredPos = null;
    public static class_243 currentPos = null;
    public static class_243 desiredPos = null;

    public static void renderOverlay(class_329 gui, class_332 graphics, float partialTicks, int width, int height) {
        class_4587 stack = graphics.method_51448();
        stack.method_22903();
        class_310 mc = class_310.method_1551();
        if (mc.field_1690.field_1842 || mc.field_1761.method_2920() == class_1934.field_9219) {
            return;
        }

        class_239 result = mc.field_1765;
        class_243 pos = null;
        Tooltippable tooltippable = null;
        if (result instanceof class_3966 entityHitResult) {
            if (entityHitResult.method_17782() instanceof Tooltippable tooltippable1) {
                tooltippable = tooltippable1;
                pos = entityHitResult.method_17782().method_30950(0f).method_1031(0.0, entityHitResult.method_17782().method_5751() / 2f, 0.0);
            }
        }
        if (result instanceof class_3965 blockHitResult) {
            pos = class_243.method_24953(blockHitResult.method_17777());
            class_2586 blockEntity = mc.field_1687.method_8321(class_2338.method_49638(pos));
            if (blockEntity instanceof Tooltippable tooltippable1) {
                tooltippable = tooltippable1;
            }
        }
        if (tooltippable == null || !tooltippable.isTooltipEnabled()) {
            hoverTicks = 0;
            lastHoveredPos = null;
            return;
        }

        hoverTicks++;
        lastHoveredPos = pos;
        List<class_2561> tooltip = tooltippable.getTooltip();
        if (tooltip.isEmpty()) {
            hoverTicks = 0;
            return;
        }

        stack.method_22903();
        int tooltipTextWidth = 0;
        for (class_5348 line : tooltip) {
            int textLineWidth = mc.field_1772.method_27525(line);
            if (textLineWidth > tooltipTextWidth) {
                tooltipTextWidth = textLineWidth;
            }
        }

        int tooltipHeight = 8;
        if (tooltip.size() > 1) {
            tooltipHeight += 2 + (tooltip.size() - 1) * 10;
        }
        int tooltipX = (width / 2) + 20;
        int tooltipY = (height / 2);
        int desiredX = tooltipX;
        int desiredY = tooltipY;

        tooltipX = Math.min(tooltipX, width - tooltipTextWidth - 20);
        tooltipY = Math.min(tooltipY, height - tooltipHeight - 20);

        float fade = class_3532.method_15363((hoverTicks + partialTicks) / 24f, 0, 1);
        Color background = tooltippable.getTheme().getColor("background");
        Color borderTop = tooltippable.getTheme().getColor("topBorder");
        Color borderBottom = tooltippable.getTheme().getColor("bottomBorder");
        float heightBonus = tooltippable.getTooltipHeight();
        float widthBonus = tooltippable.getTooltipWidth();
        float textXOffset = tooltippable.getTooltipXOffset();
        float textYOffset = tooltippable.getTooltipYOffset();
        List<VeilUIItemTooltipDataHolder> items = tooltippable.getItems();
        class_1799 istack = tooltippable.getStack() == null ? class_1799.field_8037 : tooltippable.getStack();
        if (pos != lastHoveredPos) {
            currentPos = null;
            desiredPos = null;
        }

        if (tooltippable.getWorldspace()) {
            currentPos = currentPos == null ? pos : currentPos;
            class_243 playerPos = mc.field_1773.method_19418().method_19326();
            class_2382 playerPosInt = new class_2382((int) playerPos.field_1352, (int) playerPos.field_1351, (int) playerPos.field_1350);
            class_2382 cornerInt = new class_2382((int) pos.field_1352, (int) pos.field_1351, (int) pos.field_1350);
            class_2382 diff = playerPosInt.method_35852(cornerInt);
            desiredPos = pos.method_1031(Math.round(class_3532.method_15340(Math.round(diff.method_10263()), -1, 1) * 0.5f) - 0.5f, 0.5, Math.round(class_3532.method_15340(Math.round(diff.method_10260()), -1, 1) * 0.5f) - 0.5f);
            if (fade == 0) {
                currentPos = currentPos.method_1031(0, -0.25f, 0);
                background = background.multiply(1, 1, 1, fade);
                borderTop = borderTop.multiply(1, 1, 1, fade);
                borderBottom = borderBottom.multiply(1, 1, 1, fade);
            }
            currentPos = currentPos.method_35590(desiredPos, 0.05f);
            Vector3f screenSpacePos = SpaceHelper.worldToScreenSpace(currentPos, partialTicks);
            Vector3f desiredScreenSpacePos = SpaceHelper.worldToScreenSpace(desiredPos, partialTicks);
            screenSpacePos = new Vector3f(class_3532.method_15363(screenSpacePos.x(), 0, width), class_3532.method_15363(screenSpacePos.y(), 0, height - (mc.field_1772.field_2000 * tooltip.size())), screenSpacePos.z());
            desiredScreenSpacePos = new Vector3f(class_3532.method_15363(desiredScreenSpacePos.x(), 0, width), class_3532.method_15363(desiredScreenSpacePos.y(), 0, height - (mc.field_1772.field_2000 * tooltip.size())), desiredScreenSpacePos.z());
            tooltipX = (int) screenSpacePos.x();
            tooltipY = (int) screenSpacePos.y();
            desiredX = (int) desiredScreenSpacePos.x();
            desiredY = (int) desiredScreenSpacePos.y();
        }
        UIUtils.drawHoverText(tooltippable, partialTicks, istack, stack, tooltip, tooltipX + (int) textXOffset, tooltipY + (int) textYOffset, width, height, -1, background.getHex(), borderTop.getHex(), borderBottom.getHex(), mc.field_1772, (int) widthBonus, (int) heightBonus, items, desiredX, desiredY);
        stack.method_22909();
    }

    public static void drawConnectionLine(class_4587 stack, Tooltippable tooltippable, int tooltipX, int tooltipY, int desiredX, int desiredY) {
        if (tooltippable.getTheme().getColor("connectingLine") != null) {
            stack.method_22903();
            Color color = tooltippable.getTheme().getColor("connectingLine");
            float thickness = ((NumberThemeProperty) tooltippable.getTheme().getProperty("connectingLineThickness")).getValue(Float.class);
//            stack.mulPose(Minecraft.getInstance().getEntityRenderDispatcher().cameraOrientation());
//            stack.mulPose(Vector3f.YP.rotationDegrees(180));
            Matrix4f mat = stack.method_23760().method_23761();
            RenderSystem.enableDepthTest();
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            RenderSystem.lineWidth(2);
            RenderSystem.setShader(class_757::method_34540);
            class_287 buffer = class_289.method_1348().method_1349();
            // draw a quad of thickness thickness from desiredX, desiredY to tooltipX, tooltipY with a z value of 399, starting from the top right corner and going anti-clockwise
            buffer.method_1328(class_293.class_5596.field_27382, class_290.field_1576);
            buffer.method_22918(mat, desiredX + thickness, desiredY, 399).method_22915(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha()).method_1344();
            buffer.method_22918(mat, desiredX - thickness, desiredY, 399).method_22915(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha()).method_1344();
            buffer.method_22918(mat, tooltipX - thickness, tooltipY + 3 - (tooltippable.getTooltipHeight() / 2f), 399).method_22915(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha()).method_1344();
            buffer.method_22918(mat, tooltipX + thickness, tooltipY + 3 - (tooltippable.getTooltipHeight() / 2f), 399).method_22915(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha()).method_1344();
            class_289.method_1348().method_1350();
            RenderSystem.disableBlend();
            stack.method_22909();
        }
    }
}
