package foundry.veil.api.client.graveyard.skeleton;

import foundry.veil.api.client.graveyard.render.mesh.ModelMesh;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Quaternionf;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.class_2350;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;

public class InterpolatedBone {
    private float x, y, z, pX, pY, pZ;
    public Quaternionf rotation, pRotation;
    protected Quaternionf currentRotation;
    public float xSize, ySize, zSize, pXSize, pYSize, pZSize;

    public float initialX, initialY, initialZ;
    public Quaternionf initialRotation;
    public float initialXSize, initialYSize, initialZSize;

    @Nullable
    public InterpolatedBone parent;
    public List<InterpolatedBone> children;

    public final String identifier;
    public boolean shouldRender = true;

    // list of all parents, starting from the root and going down
    public List<InterpolatedBone> parentChain;

    public InterpolatedBone(String identifier) {
        this.identifier = identifier;

        this.rotation = new Quaternionf();
        this.pRotation = new Quaternionf();
        this.currentRotation = new Quaternionf();
        this.initialRotation = new Quaternionf();

        this.xSize = 1.0F;
        this.ySize = 1.0F;
        this.zSize = 1.0F;
        this.pXSize = 1.0F;
        this.pYSize = 1.0F;
        this.pZSize = 1.0F;
        this.initialXSize = 1.0F;
        this.initialYSize = 1.0F;
        this.initialZSize = 1.0F;

        this.children = new ArrayList<>();
        this.parentChain = new ArrayList<>();
    }

    public void setInitialTransform(float x, float y, float z, Quaternionf rotation) {
        this.initialX = x;
        this.initialY = y;
        this.initialZ = z;
        this.x = this.initialX;
        this.y = this.initialY;
        this.z = this.initialZ;
        this.pX = this.initialX;
        this.pY = this.initialY;
        this.pZ = this.initialZ;
        this.initialRotation.set(rotation);
        this.rotation.set(this.initialRotation);
        this.pRotation.set(this.initialRotation);
        this.currentRotation.set(this.initialRotation);
    }

    public void reset() {
        this.x = this.initialX;
        this.y = this.initialY;
        this.z = this.initialZ;
        this.rotation.set(this.initialRotation);
        this.xSize = this.initialXSize;
        this.ySize = this.initialYSize;
        this.zSize = this.initialZSize;
    }

    protected void updatePreviousPosition() {
        this.pX = this.x;
        this.pY = this.y;
        this.pZ = this.z;
        this.pRotation.set(this.rotation);
        this.pXSize = this.xSize;
        this.pYSize = this.ySize;
        this.pZSize = this.zSize;
    }

    public void setGlobalSpaceRotation(Quaternionf globalSpaceRotation) {
        Quaternionf parentRotation = new Quaternionf();

        //add together the rotations of all parents.
        for (InterpolatedBone bone : this.parentChain) {
            parentRotation.mul(bone.rotation);
        }

        //subtract that from the global space rotation

        parentRotation.difference(globalSpaceRotation, this.rotation);
    }

    protected void tick(float deltaTime) {
    }

    public void transform(class_4587 pPoseStack, float partialTick) {
        pPoseStack.method_46416(class_3532.method_16439(partialTick, this.pX, this.x), class_3532.method_16439(partialTick, this.pY, this.y), class_3532.method_16439(partialTick, this.pZ, this.z));
        this.currentRotation = this.pRotation.slerp(this.rotation, partialTick, this.currentRotation);
        this.currentRotation.normalize();
        pPoseStack.method_22907(this.currentRotation);
        pPoseStack.method_22905(class_3532.method_16439(partialTick, this.pXSize, this.xSize), class_3532.method_16439(partialTick, this.pYSize, this.ySize), class_3532.method_16439(partialTick, this.pZSize, this.zSize));
    }

    public <T extends InterpolatedSkeleton> void render(Map<String, ModelMesh> meshes, float partialTick, class_4587 poseStack, class_4588 pVertexConsumer, int pPackedLight, int pPackedOverlay, float pRed, float pGreen, float pBlue, float pAlpha, boolean drawChildren) {
        if (!this.shouldRender) {
            return;
        }

        poseStack.method_22903();

        ModelMesh mesh = meshes.get(this.identifier);
        this.transform(poseStack, partialTick);
        if (mesh != null) {
            mesh.render(this, poseStack, pVertexConsumer, pPackedLight, pPackedOverlay, pRed, pGreen, pBlue, pAlpha);
        }

        if (drawChildren) {
            for (InterpolatedBone child : this.children) {
                child.render(meshes, partialTick, poseStack, pVertexConsumer, pPackedLight, pPackedOverlay, pRed, pGreen, pBlue, pAlpha, true);
            }
        }

        poseStack.method_22909();
    }

    public void addChild(InterpolatedBone children) {
        if (children.parent != null) {
            children.parent.children.remove(children);
        }

        this.children.add(children);
        children.parent = this;
    }

    public void setParent(InterpolatedBone parent) {
        this.parent = parent;
        parent.children.add(this);
    }

    public Matrix4f getModelSpaceTransformMatrix(class_4587 pPoseStack, float partialTick) {
        InterpolatedBone parent = this.parent;
        if (parent != null) {
            parent.getModelSpaceTransformMatrix(pPoseStack, partialTick);
        }
        this.transform(pPoseStack, partialTick);

        return pPoseStack.method_23760().method_23761();
    }

    public void rotate(float angle, class_2350.class_2351 axis) {
        switch (axis) {
            case field_11048 -> this.rotation.rotateX(angle);
            case field_11052 -> this.rotation.rotateY(angle);
            case field_11051 -> this.rotation.rotateZ(angle);
        }
    }
}
