package foundry.veil.impl.client.render.pipeline;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.*;
import foundry.veil.api.client.render.VeilRenderSystem;
import foundry.veil.api.client.render.framebuffer.AdvancedFbo;
import foundry.veil.api.client.render.framebuffer.VeilFramebuffers;
import foundry.veil.api.client.render.post.PostPipeline;
import foundry.veil.api.client.render.shader.program.ShaderProgram;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.system.NativeResource;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_291;
import net.minecraft.class_293;
import net.minecraft.class_2960;

/**
 * Default implementation of {@link PostPipeline.Context}.
 */
@ApiStatus.Internal
public class PostPipelineContext implements PostPipeline.Context, NativeResource {

    private final class_291 vbo;
    private final Map<CharSequence, Integer> samplers;
    private final Map<class_2960, AdvancedFbo> framebuffers;

    /**
     * Creates a new context to fit the specified window.
     */
    public PostPipelineContext() {
        this.vbo = new class_291(class_291.class_8555.field_44793);
        this.samplers = new HashMap<>();
        this.framebuffers = new HashMap<>();
        this.setupScreenQuad();
    }

    private void setupScreenQuad() {
        class_289 tesselator = RenderSystem.renderThreadTesselator();
        class_287 bufferBuilder = tesselator.method_1349();

        bufferBuilder.method_1328(class_293.class_5596.field_27380, class_290.field_1592);
        bufferBuilder.method_22912(-1, 1, 0).method_1344();
        bufferBuilder.method_22912(-1, -1, 0).method_1344();
        bufferBuilder.method_22912(1, 1, 0).method_1344();
        bufferBuilder.method_22912(1, -1, 0).method_1344();

        this.vbo.method_1353();
        this.vbo.method_1352(bufferBuilder.method_1326());
        class_291.method_1354();
    }

    /**
     * Marks the start of a new post run.
     */
    public void begin() {
        VeilRenderSystem.renderer().getFramebufferManager().getFramebuffers().forEach(this::setFramebuffer);
        this.setFramebuffer(VeilFramebuffers.POST, this.getDrawFramebuffer());
    }

    /**
     * Ends the running pass and cleans up resources.
     */
    public void end() {
        this.samplers.clear();
        this.framebuffers.clear();
    }

    @Override
    public void drawScreenQuad() {
        this.vbo.method_1353();
        this.vbo.method_35665();
        class_291.method_1354();
    }

    @Override
    public void setSampler(CharSequence name, int id) {
        this.samplers.put(name, id);
    }

    @Override
    public void setFramebuffer(class_2960 name, AdvancedFbo framebuffer) {
        this.framebuffers.put(name, framebuffer);
    }

    @Override
    public void applySamplers(ShaderProgram shader) {
        this.samplers.forEach(shader::addSampler);
    }

    @Override
    public @Nullable AdvancedFbo getFramebuffer(class_2960 name) {
        return this.framebuffers.get(name);
    }

    @Override
    public AdvancedFbo getDrawFramebuffer() {
        return this.framebuffers.getOrDefault(VeilFramebuffers.POST, AdvancedFbo.getMainFramebuffer());
    }

    @Override
    public void free() {
        this.vbo.close();
    }
}
