package foundry.veil.api.client.render.rendertype.layer;

import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import foundry.veil.api.client.registry.RenderTypeLayerRegistry;
import foundry.veil.api.client.render.rendertype.VeilRenderTypeBuilder;
import net.minecraft.class_2960;
import net.minecraft.class_4668;

public record TextureLayer(class_2960 texture, boolean blur, boolean mipmap) implements RenderTypeLayer {

    public static final Codec<TextureLayer> CODEC = RecordCodecBuilder.create(instance -> instance.group(
            class_2960.field_25139.fieldOf("texture").forGetter(TextureLayer::texture),
            Codec.BOOL.optionalFieldOf("blur", false).forGetter(TextureLayer::blur),
            Codec.BOOL.optionalFieldOf("mipmap", false).forGetter(TextureLayer::mipmap)
    ).apply(instance, TextureLayer::new));

    @Override
    public void addLayer(VeilRenderTypeBuilder builder) {
        builder.textureState(new class_4668.class_4683(this.texture, this.blur, this.blur));
    }

    @Override
    public RenderTypeLayerRegistry.LayerType<?> getType() {
        return RenderTypeLayerRegistry.TEXTURE.get();
    }
}
