package foundry.veil.mixin.client.shader;

import foundry.veil.api.client.render.VeilRenderSystem;
import foundry.veil.api.client.render.VeilRenderer;
import foundry.veil.api.client.render.shader.program.ShaderProgram;
import foundry.veil.impl.client.render.shader.modifier.ReplaceShaderModification;
import foundry.veil.impl.client.render.shader.modifier.ShaderModification;
import org.slf4j.Logger;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;

import java.io.IOException;
import java.util.Collection;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_5912;
import net.minecraft.class_5944;
import net.minecraft.class_757;

@Mixin(class_757.class)
public class GameRendererMixin {

    @Shadow
    @Final
    static Logger LOGGER;

    /**
     * This is needed to replace the shader instance value when shader replacement is used
     *
     * @author Ocelot
     */
    @Redirect(method = "reloadShaders", at = @At(value = "NEW", target = "(Lnet/minecraft/server/packs/resources/ResourceProvider;Ljava/lang/String;Lcom/mojang/blaze3d/vertex/VertexFormat;)Lnet/minecraft/client/renderer/ShaderInstance;"))
    public class_5944 veil$replaceShaders(class_5912 resourceProvider, String name, class_293 vertexFormat) throws IOException {
        class_2960 loc = new class_2960(name);
        class_2960 id = new class_2960(loc.method_12836(), "shaders/core/" + loc.method_12832());

        VeilRenderer renderer = VeilRenderSystem.renderer();
        Collection<ShaderModification> modifiers = renderer.getShaderModificationManager().getModifiers(id);
        if (modifiers.size() == 1) {
            ShaderModification modification = modifiers.iterator().next();
            if (modification instanceof ReplaceShaderModification replaceModification) {
                ShaderProgram shader = renderer.getShaderManager().getShader(replaceModification.veilShader());
                if (shader == null) {
                    LOGGER.error("Failed to replace vanilla shader '{}' with veil shader: {}", loc, replaceModification.veilShader());
                } else {
                    return shader.toShaderInstance();
                }
            }
        }

        return new class_5944(resourceProvider, name, vertexFormat);
    }
}
