/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.mixin.resource;

import foundry.veil.Veil;
import foundry.veil.ext.PackResourcesExtension;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import net.minecraft.class_2960;
import net.minecraft.class_3259;
import net.minecraft.class_3262;
import net.minecraft.class_3264;
import net.minecraft.class_7367;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(value={class_3259.class})
public abstract class PathPackResourcesMixin
implements class_3262,
PackResourcesExtension {
    @Shadow
    @Final
    private Path field_40001;

    @Shadow
    @Nullable
    public abstract class_7367<InputStream> method_14410(String ... var1);

    @Override
    public void veil$listResources(final PackResourcesExtension.PackResourceConsumer consumer) {
        String packId = this.method_14409();
        final String separator = this.field_40001.getFileSystem().getSeparator();
        for (final class_3264 type : class_3264.values()) {
            final Path assetPath = this.field_40001.resolve(type.method_14413());
            if (!Files.exists(assetPath, new LinkOption[0])) continue;
            try {
                Files.walkFileTree(assetPath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                        String path;
                        String[] parts = assetPath.relativize(file).toString().replace(separator, "/").split("/", 2);
                        String namespace = parts.length == 1 ? "root" : parts[0];
                        class_2960 name = class_2960.method_43902((String)namespace, (String)(path = parts.length == 1 ? parts[0] : parts[1]));
                        if (name != null) {
                            consumer.accept(type, name, assetPath, file, null);
                        }
                        return FileVisitResult.CONTINUE;
                    }
                });
            }
            catch (IOException e) {
                Veil.LOGGER.warn("Failed to list resources in {} failed!", (Object)packId, (Object)e);
            }
        }
    }

    @Override
    @Nullable
    public class_7367<InputStream> veil$getIcon() {
        return this.method_14410("pack.png");
    }
}

