/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.impl.client.render.shader.modifier;

import foundry.veil.impl.client.render.shader.modifier.ShaderModification;
import foundry.veil.impl.client.render.shader.modifier.SimpleShaderModification;
import foundry.veil.impl.client.render.shader.transformer.VeilJobParameters;
import io.github.douira.glsl_transformer.ast.node.Identifier;
import io.github.douira.glsl_transformer.ast.node.TranslationUnit;
import io.github.douira.glsl_transformer.ast.node.abstract_node.ASTNode;
import io.github.douira.glsl_transformer.ast.node.declaration.DeclarationMember;
import io.github.douira.glsl_transformer.ast.node.external_declaration.ExternalDeclaration;
import io.github.douira.glsl_transformer.ast.node.type.specifier.BuiltinNumericTypeSpecifier;
import io.github.douira.glsl_transformer.ast.node.type.specifier.TypeSpecifier;
import io.github.douira.glsl_transformer.ast.print.ASTPrinter;
import io.github.douira.glsl_transformer.ast.query.Root;
import io.github.douira.glsl_transformer.ast.query.match.Matcher;
import io.github.douira.glsl_transformer.ast.transform.ASTInjectionPoint;
import io.github.douira.glsl_transformer.ast.transform.ASTParser;
import io.github.douira.glsl_transformer.ast.traversal.ASTListener;
import io.github.douira.glsl_transformer.ast.traversal.ASTWalker;
import io.github.douira.glsl_transformer.parser.ParseShape;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_2960;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class VertexShaderModification
extends SimpleShaderModification {
    public static final Matcher<ExternalDeclaration> INPUT = new Matcher<ExternalDeclaration>("in type name;", ParseShape.EXTERNAL_DECLARATION){
        {
            Root root = ((ExternalDeclaration)this.pattern).getRoot();
            this.markClassWildcard("type", ((Identifier)root.identifierIndex.getUnique("type")).getAncestor(TypeSpecifier.class), BuiltinNumericTypeSpecifier.class);
            this.markClassWildcard("name*", ((Identifier)root.identifierIndex.getUnique("name")).getAncestor(DeclarationMember.class));
        }
    };
    private final Attribute[] attributes;
    private final Map<String, String> mapper;

    public VertexShaderModification(int version, int priority, class_2960[] includes, @Nullable String output, @Nullable String uniform, ShaderModification.Function[] functions, Attribute[] attributes) {
        super(version, priority, includes, output, uniform, functions);
        this.attributes = attributes;
        this.mapper = new HashMap<String, String>(this.attributes.length);
    }

    @Override
    public void inject(ASTParser parser, TranslationUnit tree, VeilJobParameters parameters) throws IOException {
        if (this.attributes.length > 0) {
            Int2ObjectArrayMap validInputs = new Int2ObjectArrayMap();
            Root root = tree.getRoot();
            root.processMatches(parser, tree.getChildren().stream().filter(dec -> dec.hasAncestor(INPUT.getPatternClass())), INPUT, arg_0 -> this.lambda$inject$1((Map)validInputs, arg_0));
            this.mapper.clear();
            for (Attribute attribute : this.attributes) {
                Attribute sourceAttribute = (Attribute)validInputs.get(attribute.index);
                if (sourceAttribute == null) {
                    tree.parseAndInjectNode(parser, ASTInjectionPoint.BEFORE_DECLARATIONS, "layout(location = " + attribute.index + ") in " + attribute.type + " " + attribute.name + ";");
                    this.mapper.put(attribute.name, attribute.name);
                    continue;
                }
                if (!sourceAttribute.type.equals(attribute.type)) {
                    throw new IOException("Expected attribute " + attribute.index + " to be " + attribute.type + " but was " + sourceAttribute.type);
                }
                this.mapper.put(attribute.name, sourceAttribute.name);
            }
        }
        super.inject(parser, tree, parameters);
    }

    @Override
    protected String getPlaceholder(String key) {
        String name = this.mapper.get(key);
        return name != null ? name : super.getPlaceholder(key);
    }

    private /* synthetic */ void lambda$inject$1(Map validInputs, ExternalDeclaration externalDeclaration) {
        final String[] parts = new String[]{null, null};
        ASTWalker.walk((ASTListener)new ASTListener(){

            public void enterTypeSpecifier(TypeSpecifier node) {
                parts[0] = ASTPrinter.printSimple((ASTNode)node);
            }

            public void enterDeclarationMember(DeclarationMember node) {
                parts[1] = node.getName().getName();
            }
        }, (ASTNode)externalDeclaration);
        validInputs.put(validInputs.size(), new Attribute(validInputs.size(), parts[0], parts[1]));
    }

    public record Attribute(int index, String type, String name) {
    }
}

