/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.api.client.render.shader;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import foundry.veil.Veil;
import foundry.veil.api.client.render.VeilRenderSystem;
import foundry.veil.api.client.render.VeilRenderer;
import foundry.veil.api.client.render.framebuffer.FramebufferManager;
import foundry.veil.api.client.render.post.PostProcessingManager;
import foundry.veil.api.client.render.shader.ShaderCompiler;
import foundry.veil.api.client.render.shader.ShaderException;
import foundry.veil.api.client.render.shader.ShaderSourceSet;
import foundry.veil.api.client.render.shader.definition.ShaderPreDefinitions;
import foundry.veil.api.client.render.shader.processor.ShaderCPreprocessor;
import foundry.veil.api.client.render.shader.processor.ShaderCustomProcessor;
import foundry.veil.api.client.render.shader.processor.ShaderModifyProcessor;
import foundry.veil.api.client.render.shader.program.ProgramDefinition;
import foundry.veil.api.client.render.shader.program.ShaderProgram;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.minecraft.class_156;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3302;
import net.minecraft.class_3518;
import net.minecraft.class_3694;
import net.minecraft.class_3695;
import net.minecraft.class_5912;
import net.minecraft.class_7654;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.system.NativeResource;

public class ShaderManager
implements class_3302,
Closeable {
    private static final Gson GSON = new GsonBuilder().registerTypeAdapter(class_2960.class, (Object)new class_2960.class_2961()).registerTypeAdapter(ProgramDefinition.class, (Object)new ProgramDefinition.Deserializer()).create();
    public static final class_7654 INCLUDE_LISTER = new class_7654("pinwheel/shaders/include", ".glsl");
    public static final ShaderSourceSet PROGRAM_SET = new ShaderSourceSet("pinwheel/shaders/program");
    public static final ShaderSourceSet DEFERRED_SET = new ShaderSourceSet("pinwheel/shaders/deferred");
    private static final Map<Integer, String> TYPES = Map.of(35633, "vertex", 36488, "tesselation_control", 36487, "tesselation_evaluation", 36313, "geometry", 35632, "fragment", 37305, "compute");
    private final ShaderSourceSet sourceSet;
    private final ShaderPreDefinitions definitions;
    private final Map<class_2960, ShaderProgram> shaders;
    private final Map<class_2960, ShaderProgram> shadersView;
    private final Set<class_2960> dirtyShaders;
    private CompletableFuture<Void> reloadFuture;
    private CompletableFuture<Void> recompileFuture;

    public ShaderManager(ShaderSourceSet sourceSet, ShaderPreDefinitions shaderPreDefinitions) {
        this.sourceSet = sourceSet;
        this.definitions = shaderPreDefinitions;
        this.definitions.addListener(this::onDefinitionChanged);
        this.shaders = new HashMap<class_2960, ShaderProgram>();
        this.shadersView = Collections.unmodifiableMap(this.shaders);
        this.dirtyShaders = new HashSet<class_2960>();
        this.reloadFuture = CompletableFuture.completedFuture(null);
        this.recompileFuture = CompletableFuture.completedFuture(null);
    }

    private void onDefinitionChanged(String definition) {
        this.shaders.values().forEach(shader -> {
            if (shader.getDefinitionDependencies().contains(definition)) {
                Veil.LOGGER.debug("{} changed, recompiling {}", (Object)definition, (Object)shader.getId());
                this.scheduleRecompile(shader.getId());
            }
        });
    }

    private ProgramDefinition parseDefinition(class_2960 id, class_5912 provider) throws IOException {
        ProgramDefinition programDefinition;
        block9: {
            BufferedReader reader = provider.openAsReader(this.sourceSet.getShaderDefinitionLister().method_45112(id));
            try {
                ProgramDefinition definition = (ProgramDefinition)class_3518.method_15276((Gson)GSON, (Reader)reader, ProgramDefinition.class);
                if (definition.vertex() == null && definition.tesselationControl() == null && definition.tesselationEvaluation() == null && definition.geometry() == null && definition.fragment() == null && definition.compute() == null) {
                    throw new JsonSyntaxException("Shader programs must define at least 1 shader type");
                }
                programDefinition = definition;
                if (reader == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        try {
                            ((Reader)reader).close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (JsonParseException e) {
                    throw new IOException(e);
                }
            }
            ((Reader)reader).close();
        }
        return programDefinition;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void readShader(class_3300 resourceManager, Map<class_2960, ProgramDefinition> definitions, Map<class_2960, class_3298> shaderSources, class_2960 id) {
        HashSet<class_2960> checkedSources = new HashSet<class_2960>();
        try {
            ProgramDefinition definition = this.parseDefinition(id, (class_5912)resourceManager);
            if (definitions.put(id, definition) != null) {
                throw new IllegalStateException("Duplicate shader ignored with ID " + id);
            }
            for (Int2ObjectMap.Entry shader : definition.shaders().int2ObjectEntrySet()) {
                class_7654 typeConverter = this.sourceSet.getTypeConverter(shader.getIntKey());
                class_2960 location = typeConverter.method_45112(((ProgramDefinition.ShaderSource)shader.getValue()).location());
                if (!checkedSources.add(location)) continue;
                class_3298 resource = resourceManager.getResourceOrThrow(location);
                try {
                    InputStream stream = resource.method_14482();
                    try {
                        byte[] source = stream.readAllBytes();
                        class_3298 fileResource = new class_3298(resource.method_45304(), () -> new ByteArrayInputStream(source));
                        shaderSources.put(location, fileResource);
                    }
                    finally {
                        if (stream == null) continue;
                        stream.close();
                    }
                }
                catch (Throwable t) {
                    throw new IOException("Failed to load " + ShaderManager.getTypeName(shader.getIntKey()) + " shader", t);
                    return;
                }
            }
        }
        catch (JsonParseException | IOException | IllegalArgumentException e) {
            Veil.LOGGER.error("Couldn't parse shader {} from {}", new Object[]{id, this.sourceSet.getShaderDefinitionLister().method_45112(id), e});
        }
    }

    private Map<class_2960, class_3298> readIncludes(class_3300 resourceManager) {
        HashMap<class_2960, class_3298> shaderSources = new HashMap<class_2960, class_3298>();
        HashSet<class_2960> checkedSources = new HashSet<class_2960>();
        for (Map.Entry entry : INCLUDE_LISTER.method_45113(resourceManager).entrySet()) {
            class_2960 location = (class_2960)entry.getKey();
            class_2960 id = INCLUDE_LISTER.method_45115(location);
            if (!checkedSources.add(location)) continue;
            try {
                class_3298 resource = resourceManager.getResourceOrThrow(location);
                InputStream stream = resource.method_14482();
                try {
                    byte[] source = stream.readAllBytes();
                    class_3298 fileResource = new class_3298(resource.method_45304(), () -> new ByteArrayInputStream(source));
                    shaderSources.put(location, fileResource);
                }
                finally {
                    if (stream == null) continue;
                    stream.close();
                }
            }
            catch (JsonParseException | IOException | IllegalArgumentException e) {
                Veil.LOGGER.error("Couldn't parse shader import {} from {}", new Object[]{id, location, e});
            }
        }
        return shaderSources;
    }

    private void compile(ShaderProgram program, ProgramDefinition definition, ShaderCompiler compiler) {
        class_2960 id = program.getId();
        try {
            program.compile(new ShaderCompiler.Context(this.definitions, this.sourceSet, definition), compiler);
        }
        catch (ShaderException e) {
            Veil.LOGGER.error("Failed to create shader {}: {}", (Object)id, (Object)e.getMessage());
            String error = e.getGlError();
            if (error != null) {
                Veil.LOGGER.warn(error);
            }
        }
        catch (Exception e) {
            Veil.LOGGER.error("Failed to create shader: {}", (Object)id, (Object)e);
        }
    }

    private ShaderCompiler addProcessors(ShaderCompiler compiler, class_5912 provider) {
        return compiler.addDefaultProcessors().addPreprocessor(new ShaderCPreprocessor(), false).addPreprocessor(new ShaderModifyProcessor(), false).addPreprocessor(new ShaderCustomProcessor(provider), false).addPreprocessor(new ShaderCPreprocessor(), false);
    }

    public void recompile(class_2960 id, class_5912 provider) {
        try (ShaderCompiler compiler = this.addProcessors(ShaderCompiler.direct(provider), provider);){
            this.recompile(id, provider, compiler);
        }
    }

    public void recompile(class_2960 id, class_5912 provider, ShaderCompiler compiler) {
        ShaderProgram program = this.shaders.get(id);
        if (program == null) {
            Veil.LOGGER.error("Failed to recompile unknown shader: {}", (Object)id);
            return;
        }
        try {
            this.compile(program, this.parseDefinition(id, provider), compiler);
        }
        catch (Exception e) {
            Veil.LOGGER.error("Failed to read shader definition: {}", (Object)id, (Object)e);
        }
    }

    public void setGlobal(Consumer<ShaderProgram> setter) {
        this.shaders.values().forEach(setter);
    }

    @Nullable
    public ShaderProgram getShader(class_2960 id) {
        return this.shaders.get(id);
    }

    public Map<class_2960, ShaderProgram> getShaders() {
        return this.shadersView;
    }

    public ShaderSourceSet getSourceSet() {
        return this.sourceSet;
    }

    private ReloadState prepare(class_3300 resourceManager, Collection<class_2960> shaders) {
        HashMap<class_2960, ProgramDefinition> definitions = new HashMap<class_2960, ProgramDefinition>();
        HashMap<class_2960, class_3298> shaderSources = new HashMap<class_2960, class_3298>();
        for (class_2960 key : shaders) {
            this.readShader(resourceManager, definitions, shaderSources, key);
        }
        shaderSources.putAll(this.readIncludes(resourceManager));
        return new ReloadState(definitions, shaderSources);
    }

    private void apply(ReloadState reloadState) {
        this.shaders.values().forEach(NativeResource::free);
        this.shaders.clear();
        class_5912 sourceProvider = loc -> Optional.ofNullable(reloadState.shaderSources().get(loc));
        try (ShaderCompiler compiler = this.addProcessors(ShaderCompiler.cached(sourceProvider), sourceProvider);){
            for (Map.Entry<class_2960, ProgramDefinition> entry : reloadState.definitions().entrySet()) {
                class_2960 id = entry.getKey();
                ShaderProgram program = ShaderProgram.create(id);
                this.compile(program, entry.getValue(), compiler);
                this.shaders.put(id, program);
            }
        }
        VeilRenderSystem.finalizeShaderCompilation();
        Veil.LOGGER.info("Loaded {} shaders from: {}", (Object)this.shaders.size(), (Object)this.sourceSet.getFolder());
    }

    private void applyRecompile(ReloadState reloadState, Collection<class_2960> shaders) {
        class_5912 sourceProvider = loc -> Optional.ofNullable(reloadState.shaderSources().get(loc));
        try (ShaderCompiler compiler = this.addProcessors(ShaderCompiler.cached(sourceProvider), sourceProvider);){
            for (Map.Entry<class_2960, ProgramDefinition> entry : reloadState.definitions().entrySet()) {
                class_2960 id = entry.getKey();
                ShaderProgram program = this.getShader(id);
                if (program == null) {
                    Veil.LOGGER.warn("Failed to recompile shader: {}", (Object)id);
                    continue;
                }
                this.compile(program, entry.getValue(), compiler);
            }
        }
        VeilRenderSystem.finalizeShaderCompilation();
        Veil.LOGGER.info("Recompiled {} shaders from: {}", (Object)shaders.size(), (Object)this.sourceSet.getFolder());
    }

    private void scheduleRecompile(int attempt) {
        class_310 client = class_310.method_1551();
        client.method_18858(() -> {
            HashSet<class_2960> shaders;
            if (!this.recompileFuture.isDone()) {
                return;
            }
            Set<class_2960> set = this.dirtyShaders;
            synchronized (set) {
                shaders = new HashSet<class_2960>(this.dirtyShaders);
                this.dirtyShaders.clear();
            }
            this.recompileFuture = ((CompletableFuture)CompletableFuture.supplyAsync(() -> this.prepare(client.method_1478(), shaders), class_156.method_18349()).thenAcceptAsync(state -> this.applyRecompile((ReloadState)state, (Collection<class_2960>)shaders), (Executor)client)).handle((value, e) -> {
                if (e != null) {
                    Veil.LOGGER.error("Error recompiling shaders", e);
                }
                Set<class_2960> set = this.dirtyShaders;
                synchronized (set) {
                    if (this.dirtyShaders.isEmpty()) {
                        return value;
                    }
                }
                if (attempt >= 3) {
                    Veil.LOGGER.error("Failed to recompile shaders after {} attempts", (Object)attempt);
                    return value;
                }
                this.scheduleRecompile(attempt + 1);
                return value;
            });
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scheduleRecompile(class_2960 shader) {
        Set<class_2960> set = this.dirtyShaders;
        synchronized (set) {
            this.dirtyShaders.add(shader);
        }
        if (!this.recompileFuture.isDone()) {
            return;
        }
        this.scheduleRecompile(0);
    }

    public CompletableFuture<Void> method_25931(class_3302.class_4045 preparationBarrier, class_3300 resourceManager, class_3695 preparationsProfiler, class_3695 reloadProfiler, Executor backgroundExecutor, Executor gameExecutor) {
        if (this.reloadFuture != null && !this.reloadFuture.isDone()) {
            return this.reloadFuture.thenCompose(arg_0 -> ((class_3302.class_4045)preparationBarrier).method_18352(arg_0));
        }
        this.reloadFuture = this.recompileFuture.thenCompose(unused -> ((CompletableFuture)CompletableFuture.supplyAsync(() -> {
            class_7654 lister = this.sourceSet.getShaderDefinitionLister();
            Set<class_2960> shaderIds = lister.method_45113(resourceManager).keySet().stream().map(arg_0 -> ((class_7654)lister).method_45115(arg_0)).collect(Collectors.toSet());
            return this.prepare(resourceManager, shaderIds);
        }, backgroundExecutor).thenCompose(arg_0 -> ((class_3302.class_4045)preparationBarrier).method_18352(arg_0))).thenAcceptAsync(this::apply, gameExecutor));
        return this.reloadFuture;
    }

    public String method_22322() {
        return this.getClass().getSimpleName() + " " + this.getSourceSet().getFolder();
    }

    public CompletableFuture<Void> reload(class_3300 resourceManager, Executor backgroundExecutor, Executor gameExecutor) {
        VeilRenderer renderer = VeilRenderSystem.renderer();
        FramebufferManager framebufferManager = renderer.getFramebufferManager();
        PostProcessingManager postProcessingManager = renderer.getPostProcessingManager();
        this.reloadFuture = CompletableFuture.allOf(this.reload(this, resourceManager, backgroundExecutor, gameExecutor), this.reload((class_3302)framebufferManager, resourceManager, backgroundExecutor, gameExecutor), this.reload((class_3302)postProcessingManager, resourceManager, backgroundExecutor, gameExecutor));
        return this.reloadFuture;
    }

    private CompletableFuture<Void> reload(class_3302 listener, class_3300 resourceManager, Executor backgroundExecutor, Executor gameExecutor) {
        return listener.method_25931(CompletableFuture::completedFuture, resourceManager, (class_3695)class_3694.field_16280, (class_3695)class_3694.field_16280, backgroundExecutor, gameExecutor);
    }

    public CompletableFuture<Void> getReloadFuture() {
        return this.reloadFuture;
    }

    public CompletableFuture<Void> getRecompileFuture() {
        return this.recompileFuture;
    }

    public static String getTypeName(int type) {
        String value = TYPES.get(type);
        return value != null ? value : "0x" + Integer.toHexString(type);
    }

    @Override
    public void close() {
        this.shaders.values().forEach(NativeResource::free);
        this.shaders.clear();
    }

    private record ReloadState(Map<class_2960, ProgramDefinition> definitions, Map<class_2960, class_3298> shaderSources) {
    }
}

