package foundry.veil.mixin.client.shader;

import foundry.veil.impl.client.render.shader.ShaderProgramImpl;
import net.minecraft.class_285;
import net.minecraft.class_3679;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(class_285.class)
public class ProgramManagerMixin {

    @Inject(method = "createProgram", at = @At("HEAD"), cancellable = true)
    private static void veil$cancelProgram(CallbackInfoReturnable<Integer> cir) {
        if (ShaderProgramImpl.Wrapper.constructing) {
            cir.setReturnValue(0);
        }
    }

    @Inject(method = "linkShader", at = @At("HEAD"), cancellable = true)
    private static void veil$cancelLinkShader(class_3679 shader, CallbackInfo ci) {
        if (shader instanceof ShaderProgramImpl.Wrapper) {
            ci.cancel();
        }
    }
}
