package foundry.veil.api.client.render.shader.texture;

import com.mojang.serialization.Codec;
import net.minecraft.class_2960;

/**
 * Source of a shader texture using a registered texture.
 *
 * @param location The location of the texture
 * @author Ocelot
 */
public record LocationSource(class_2960 location) implements ShaderTextureSource {

    public static final Codec<LocationSource> CODEC = class_2960.field_25139.fieldOf("location").xmap(LocationSource::new, LocationSource::location).codec();

    @Override
    public int getId(Context context) {
        return context.getTexture(this.location).method_4624();
    }

    @Override
    public Type getType() {
        return Type.LOCATION;
    }
}
