package foundry.veil.api.client.render.rendertype.layer;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import foundry.veil.api.client.registry.RenderTypeLayerRegistry;
import foundry.veil.api.client.render.rendertype.VeilRenderTypeBuilder;
import java.util.Arrays;
import net.minecraft.class_4668;

public record MultiTextureLayer(TextureLayer[] textures) implements RenderTypeLayer {

    public static final Codec<MultiTextureLayer> CODEC = TextureLayer.CODEC.listOf()
            .flatXmap(textures -> textures.size() < 2 ? DataResult.error(() -> "At least 2 textures must be specified") : DataResult.success(new MultiTextureLayer(textures.toArray(TextureLayer[]::new))),
                    layer -> DataResult.success(Arrays.asList(layer.textures))).fieldOf("textures").codec();

    @Override
    public void addLayer(VeilRenderTypeBuilder builder) {
        class_4668.class_5940.class_5941 textureBuilder = class_4668.class_5940.method_34560();
        for (TextureLayer texture : this.textures) {
            textureBuilder.method_34563(texture.texture(), texture.blur(), texture.mipmap());
        }
        builder.textureState(textureBuilder.method_34562());
    }

    @Override
    public RenderTypeLayerRegistry.LayerType<?> getType() {
        return RenderTypeLayerRegistry.MULTI_TEXTURE.get();
    }
}
