package foundry.veil.mixin.resource;

import foundry.veil.Veil;
import foundry.veil.ext.PackResourcesExtension;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import net.minecraft.class_2960;
import net.minecraft.class_3259;
import net.minecraft.class_3262;
import net.minecraft.class_3264;
import net.minecraft.class_7367;

@Mixin(class_3259.class)
public abstract class PathPackResourcesMixin implements class_3262, PackResourcesExtension {

    @Shadow
    @Nullable
    public abstract class_7367<InputStream> method_14410(String... $$0);

    @Shadow
    @Final
    private Path root;

    @Override
    public void veil$listResources(PackResourceConsumer consumer) {
        String packId = this.method_14409();

        String separator = this.root.getFileSystem().getSeparator();

        for (class_3264 type : class_3264.values()) {
            Path assetPath = this.root.resolve(type.method_14413());
            if (!Files.exists(assetPath)) {
                continue;
            }

            try {
                Files.walkFileTree(assetPath, new SimpleFileVisitor<>() {
                    @Override
                    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                        String[] parts = assetPath.relativize(file).toString().replace(separator, "/").split("/", 2);
                        String namespace = parts.length == 1 ? "root" : parts[0];
                        String path = parts.length == 1 ? parts[0] : parts[1];
                        class_2960 name = class_2960.method_43902(namespace, path);

                        if (name != null) {
                            consumer.accept(type, name, assetPath, file, null);
                        }

                        return FileVisitResult.CONTINUE;
                    }
                });
            } catch (IOException e) {
                Veil.LOGGER.warn("Failed to list resources in {} failed!", packId, e);
            }
        }
    }

    @Override
    public @Nullable class_7367<InputStream> veil$getIcon() {
        return this.method_14410("pack.png");
    }
}
