/*
 * Decompiled with CFR 0.152.
 */
package com.terraformersmc.terraform.wood.block;

import com.terraformersmc.terraform.wood.block.BareSmallLogBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.ParticleUtils;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class SmallLogBlock
extends BareSmallLogBlock {
    public static final BooleanProperty HAS_LEAVES = BooleanProperty.m_61465_((String)"has_leaves");
    private final Block leaves;

    public SmallLogBlock(Block leaves, BlockBehaviour.Properties settings) {
        super(settings);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)AXIS, (Comparable)Direction.Axis.Y)).m_61124_((Property)UP, (Comparable)Boolean.valueOf(false))).m_61124_((Property)DOWN, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WEST, (Comparable)Boolean.valueOf(false))).m_61124_((Property)EAST, (Comparable)Boolean.valueOf(false))).m_61124_((Property)NORTH, (Comparable)Boolean.valueOf(false))).m_61124_((Property)SOUTH, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)HAS_LEAVES, (Comparable)Boolean.valueOf(false)));
        this.leaves = leaves;
    }

    public static SmallLogBlock of(Block leaves, MapColor color) {
        return new SmallLogBlock(leaves, BlockBehaviour.Properties.m_284310_().m_284495_(state -> (Boolean)state.m_61143_((Property)HAS_LEAVES) != false ? leaves.m_284356_() : color).m_60978_(2.0f).m_60918_(SoundType.f_56736_).m_278183_());
    }

    public static SmallLogBlock of(Block leaves, MapColor wood, MapColor bark) {
        return new SmallLogBlock(leaves, BlockBehaviour.Properties.m_284310_().m_284495_(state -> (Boolean)state.m_61143_((Property)HAS_LEAVES) != false ? leaves.m_284356_() : ((Boolean)state.m_61143_((Property)UP) != false ? wood : bark)).m_60978_(2.0f).m_60918_(SoundType.f_56736_).m_278183_());
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_214162_(BlockState state, Level world, BlockPos pos, RandomSource random) {
        if (!((Boolean)state.m_61143_((Property)HAS_LEAVES)).booleanValue()) {
            return;
        }
        if (!world.m_46758_(pos.m_7494_())) {
            return;
        }
        if (random.m_188503_(15) != 1) {
            return;
        }
        BlockPos lv = pos.m_7495_();
        BlockState lv2 = world.m_8055_(lv);
        if (lv2.m_60815_() && lv2.m_60783_((BlockGetter)world, lv, Direction.UP)) {
            return;
        }
        ParticleUtils.m_272037_((Level)world, (BlockPos)pos, (RandomSource)random, (ParticleOptions)ParticleTypes.f_123803_);
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult result) {
        ItemStack held = player.m_21120_(hand);
        if (held.m_41613_() >= 1 && held.m_41720_() == Item.f_41373_.get(this.leaves) && !((Boolean)state.m_61143_((Property)HAS_LEAVES)).booleanValue()) {
            if (!player.m_7500_()) {
                held.m_41774_(1);
            }
            SoundType sounds = this.leaves.m_49966_().m_60827_();
            world.m_5594_(player, pos, sounds.m_56777_(), SoundSource.BLOCKS, (sounds.m_56773_() + 1.0f) / 2.0f, sounds.m_56774_() * 0.8f);
            BlockState previous = state;
            state = (BlockState)state.m_61124_((Property)HAS_LEAVES, (Comparable)Boolean.valueOf(true));
            if (((Boolean)state.m_61143_((Property)UP)).booleanValue() && world.m_8055_(pos.m_7494_()).m_60734_() instanceof LeavesBlock) {
                state = (BlockState)state.m_61124_((Property)UP, (Comparable)Boolean.valueOf(false));
            }
            if (((Boolean)state.m_61143_((Property)DOWN)).booleanValue() && world.m_8055_(pos.m_7495_()).m_60734_() instanceof LeavesBlock) {
                state = (BlockState)state.m_61124_((Property)DOWN, (Comparable)Boolean.valueOf(false));
            }
            if (((Boolean)state.m_61143_((Property)WEST)).booleanValue() && world.m_8055_(pos.m_122024_()).m_60734_() instanceof LeavesBlock) {
                state = (BlockState)state.m_61124_((Property)WEST, (Comparable)Boolean.valueOf(false));
            }
            if (((Boolean)state.m_61143_((Property)EAST)).booleanValue() && world.m_8055_(pos.m_122029_()).m_60734_() instanceof LeavesBlock) {
                state = (BlockState)state.m_61124_((Property)EAST, (Comparable)Boolean.valueOf(false));
            }
            if (((Boolean)state.m_61143_((Property)NORTH)).booleanValue() && world.m_8055_(pos.m_122012_()).m_60734_() instanceof LeavesBlock) {
                state = (BlockState)state.m_61124_((Property)NORTH, (Comparable)Boolean.valueOf(false));
            }
            if (((Boolean)state.m_61143_((Property)SOUTH)).booleanValue() && world.m_8055_(pos.m_122019_()).m_60734_() instanceof LeavesBlock) {
                state = (BlockState)state.m_61124_((Property)SOUTH, (Comparable)Boolean.valueOf(false));
            }
            world.m_46597_(pos, SmallLogBlock.m_49897_((BlockState)previous, (BlockState)state, (LevelAccessor)world, (BlockPos)pos));
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.FAIL;
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{HAS_LEAVES});
    }

    protected boolean shouldConnectTo(BlockState state, boolean solid, boolean leaves) {
        Block block = state.m_60734_();
        return solid || !leaves && block instanceof LeavesBlock || block instanceof BareSmallLogBlock;
    }

    @Override
    public BlockState getNeighborUpdateState(BlockState state, Direction fromDirection, BlockState neighbor, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            world.m_186469_(pos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)world));
        }
        boolean leaves = (Boolean)state.m_61143_((Property)HAS_LEAVES);
        boolean up = fromDirection == Direction.UP && this.shouldConnectTo(neighbor, neighbor.m_60783_((BlockGetter)world, neighborPos, Direction.DOWN), leaves) || (Boolean)state.m_61143_((Property)UP) != false;
        boolean down = fromDirection == Direction.DOWN && this.shouldConnectTo(neighbor, neighbor.m_60783_((BlockGetter)world, neighborPos, Direction.UP), leaves) || (Boolean)state.m_61143_((Property)DOWN) != false;
        boolean north = fromDirection == Direction.NORTH && this.shouldConnectTo(neighbor, neighbor.m_60783_((BlockGetter)world, neighborPos, Direction.SOUTH), leaves) || (Boolean)state.m_61143_((Property)NORTH) != false;
        boolean east = fromDirection == Direction.EAST && this.shouldConnectTo(neighbor, neighbor.m_60783_((BlockGetter)world, neighborPos, Direction.WEST), leaves) || (Boolean)state.m_61143_((Property)EAST) != false;
        boolean south = fromDirection == Direction.SOUTH && this.shouldConnectTo(neighbor, neighbor.m_60783_((BlockGetter)world, neighborPos, Direction.NORTH), leaves) || (Boolean)state.m_61143_((Property)SOUTH) != false;
        boolean west = fromDirection == Direction.WEST && this.shouldConnectTo(neighbor, neighbor.m_60783_((BlockGetter)world, neighborPos, Direction.EAST), leaves) || (Boolean)state.m_61143_((Property)WEST) != false;
        return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)state.m_61124_((Property)UP, (Comparable)Boolean.valueOf(up))).m_61124_((Property)DOWN, (Comparable)Boolean.valueOf(down))).m_61124_((Property)NORTH, (Comparable)Boolean.valueOf(north))).m_61124_((Property)EAST, (Comparable)Boolean.valueOf(east))).m_61124_((Property)SOUTH, (Comparable)Boolean.valueOf(south))).m_61124_((Property)WEST, (Comparable)Boolean.valueOf(west));
    }

    @Override
    public VoxelShape m_5940_(BlockState state, BlockGetter view, BlockPos pos, CollisionContext context) {
        return (Boolean)state.m_61143_((Property)HAS_LEAVES) != false ? Shapes.m_83144_() : this.boundingShapes[this.getShapeIndex(state)];
    }

    @Override
    public VoxelShape m_5939_(BlockState state, BlockGetter view, BlockPos pos, CollisionContext context) {
        return (Boolean)state.m_61143_((Property)HAS_LEAVES) != false ? Shapes.m_83144_() : this.collisionShapes[this.getShapeIndex(state)];
    }

    public VoxelShape m_7952_(BlockState state, BlockGetter world, BlockPos pos) {
        return this.collisionShapes[this.getShapeIndex(state)];
    }

    public VoxelShape m_5909_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return this.collisionShapes[this.getShapeIndex(state)];
    }
}

