/*
 * Decompiled with CFR 0.152.
 */
package com.terraformersmc.terraform.wood;

import com.terraformersmc.terraform.wood.mixin.AxeItemAccessor;
import java.util.Map;
import java.util.Objects;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StrippableBlockRegistry {
    private static final Logger LOGGER = LoggerFactory.getLogger(StrippableBlockRegistry.class);

    public static void register(Block input, Block stripped) {
        StrippableBlockRegistry.requireNonNullAndAxisProperty(input, "input block");
        StrippableBlockRegistry.requireNonNullAndAxisProperty(stripped, "stripped block");
        Block old = StrippableBlockRegistry.getRegistry().put(input, stripped);
        if (old != null) {
            LOGGER.debug("Replaced old stripping mapping from {} to {} with {}", new Object[]{input, old, stripped});
        }
    }

    private static void requireNonNullAndAxisProperty(Block block, String name) {
        Objects.requireNonNull(block, name + " cannot be null");
        if (!block.m_49965_().m_61092_().contains(BlockStateProperties.f_61365_)) {
            throw new IllegalArgumentException(name + " must have the 'axis' property");
        }
    }

    private static Map<Block, Block> getRegistry() {
        return AxeItemAccessor.getSTRIPPED_BLOCKS();
    }
}

