/*
 * Decompiled with CFR 0.152.
 */
package com.terraformersmc.terraform.leaves.block;

import com.terraformersmc.terraform.leaves.block.TransparentLeavesBlock;
import java.util.OptionalInt;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;

public class ExtendedLeavesBlock
extends TransparentLeavesBlock {
    public static final int MAX_EXTENDED_DISTANCE = 7;
    public static final int MAX_TOTAL_DISTANCE = 14;
    public static final IntegerProperty EXTENDED_DISTANCE = IntegerProperty.m_61631_((String)"extended_distance", (int)0, (int)7);

    public ExtendedLeavesBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)f_54418_, (Comparable)Integer.valueOf(7))).m_61124_((Property)EXTENDED_DISTANCE, (Comparable)Integer.valueOf(7))).m_61124_((Property)f_54419_, (Comparable)Boolean.valueOf(false))).m_61124_((Property)f_221367_, (Comparable)Boolean.valueOf(false)));
    }

    public boolean m_6724_(BlockState state) {
        return ExtendedLeavesBlock.getExtendedDistance(state) == 14 && (Boolean)state.m_61143_((Property)f_54419_) == false;
    }

    public boolean m_221385_(BlockState state) {
        return (Boolean)state.m_61143_((Property)f_54419_) == false && ExtendedLeavesBlock.getExtendedDistance(state) == 14;
    }

    public void m_213897_(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        world.m_7731_(pos, ExtendedLeavesBlock.updateDistanceFromLogs(state, (LevelAccessor)world, pos), 3);
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        int distance;
        if (((Boolean)state.m_61143_((Property)f_221367_)).booleanValue()) {
            world.m_186469_(pos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)world));
        }
        if ((distance = ExtendedLeavesBlock.getDistanceFromLog(neighborState) + 1) != 1 || ExtendedLeavesBlock.getExtendedDistance(state) != distance) {
            world.m_186460_(pos, (Block)this, 1);
        }
        return state;
    }

    private static BlockState updateDistanceFromLogs(BlockState state, LevelAccessor world, BlockPos pos) {
        int distance = 14;
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        for (Direction direction : Direction.values()) {
            mutable.m_122159_((Vec3i)pos, direction);
            distance = Math.min(distance, ExtendedLeavesBlock.getDistanceFromLog(world.m_8055_((BlockPos)mutable)) + 1);
            if (distance == 1) break;
        }
        return ExtendedLeavesBlock.setExtendedDistance(state, distance);
    }

    private static int getDistanceFromLog(BlockState state) {
        return ExtendedLeavesBlock.getOptionalDistanceFromLog(state).orElse(14);
    }

    public static OptionalInt getOptionalDistanceFromLog(BlockState state) {
        if (state.m_204336_(BlockTags.f_13106_)) {
            return OptionalInt.of(0);
        }
        Block block = state.m_60734_();
        if (block instanceof ExtendedLeavesBlock) {
            return OptionalInt.of(ExtendedLeavesBlock.getExtendedDistance(state));
        }
        if (state.m_61138_((Property)f_54418_)) {
            int distance = (Integer)state.m_61143_((Property)f_54418_);
            return OptionalInt.of(distance < 7 ? distance : 14);
        }
        return OptionalInt.empty();
    }

    public static int getExtendedDistance(BlockState state) {
        return (Integer)state.m_61143_((Property)f_54418_) + state.m_61145_((Property)EXTENDED_DISTANCE).orElse(0);
    }

    public static BlockState setExtendedDistance(BlockState state, int distance) {
        if (state.m_61138_((Property)EXTENDED_DISTANCE)) {
            if (distance > 7) {
                return (BlockState)((BlockState)state.m_61124_((Property)f_54418_, (Comparable)Integer.valueOf(7))).m_61124_((Property)EXTENDED_DISTANCE, (Comparable)Integer.valueOf(distance - 7));
            }
            return (BlockState)((BlockState)state.m_61124_((Property)f_54418_, (Comparable)Integer.valueOf(distance))).m_61124_((Property)EXTENDED_DISTANCE, (Comparable)Integer.valueOf(0));
        }
        return (BlockState)state.m_61124_((Property)f_54418_, (Comparable)Integer.valueOf(distance));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{EXTENDED_DISTANCE});
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        FluidState fluidState = context.m_43725_().m_6425_(context.m_8083_());
        BlockState blockState = (BlockState)((BlockState)this.m_49966_().m_61124_((Property)f_54419_, (Comparable)Boolean.valueOf(true))).m_61124_((Property)f_221367_, (Comparable)Boolean.valueOf(fluidState.m_76152_() == Fluids.f_76193_));
        return ExtendedLeavesBlock.updateDistanceFromLogs(blockState, (LevelAccessor)context.m_43725_(), context.m_8083_());
    }

    public boolean m_6104_(BlockState state, BlockState neighborState, Direction offset) {
        return neighborState.m_60734_() instanceof ExtendedLeavesBlock;
    }
}

