/*
 * Decompiled with CFR 0.152.
 */
package com.terraformersmc.terraform.boat.impl.client;

import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.util.Pair;
import com.terraformersmc.terraform.boat.api.TerraformBoatType;
import com.terraformersmc.terraform.boat.api.TerraformBoatTypeRegistry;
import com.terraformersmc.terraform.boat.api.client.TerraformBoatClientHelper;
import com.terraformersmc.terraform.boat.impl.entity.TerraformBoatHolder;
import java.util.Map;
import net.minecraft.client.model.BoatModel;
import net.minecraft.client.model.ChestBoatModel;
import net.minecraft.client.model.ChestRaftModel;
import net.minecraft.client.model.ListModel;
import net.minecraft.client.model.RaftModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.entity.BoatRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class TerraformBoatEntityRenderer
extends BoatRenderer {
    private final Map<TerraformBoatType, Pair<ResourceLocation, ListModel<Boat>>> texturesAndModels = (Map)TerraformBoatTypeRegistry.INSTANCE.m_6579_().stream().collect(ImmutableMap.toImmutableMap(entry -> (TerraformBoatType)entry.getValue(), entry -> {
        boolean raft = ((TerraformBoatType)entry.getValue()).isRaft();
        String prefix = raft ? (chest ? "chest_raft/" : "raft/") : (chest ? "chest_boat/" : "boat/");
        ResourceLocation id = ((ResourceKey)entry.getKey()).m_135782_();
        ResourceLocation textureId = new ResourceLocation(id.m_135827_(), "textures/entity/" + prefix + id.m_135815_() + ".png");
        ModelLayerLocation layer = TerraformBoatClientHelper.getLayer(id, raft, chest);
        ListModel<Boat> model = this.createModel(context.m_174023_(layer), raft, chest);
        return new Pair((Object)textureId, model);
    }));

    public TerraformBoatEntityRenderer(EntityRendererProvider.Context context, boolean chest) {
        super(context, chest);
    }

    public Pair<ResourceLocation, ListModel<Boat>> getTextureAndModel(TerraformBoatHolder holder) {
        return this.texturesAndModels.get(holder.getTerraformBoat());
    }

    public Pair<ResourceLocation, ListModel<Boat>> getModelWithLocation(Boat boat) {
        if (boat instanceof TerraformBoatHolder) {
            TerraformBoatHolder boatHolder = (TerraformBoatHolder)boat;
            return this.getTextureAndModel(boatHolder);
        }
        return super.getModelWithLocation(boat);
    }

    private ListModel<Boat> createModel(ModelPart part, boolean raft, boolean chest) {
        if (raft) {
            return chest ? new ChestRaftModel(part) : new RaftModel(part);
        }
        return chest ? new ChestBoatModel(part) : new BoatModel(part);
    }
}

