/*
 * Decompiled with CFR 0.152.
 */
package com.terraformersmc.terraform.boat.api.client;

import com.terraformersmc.terraform.boat.impl.client.TerraformBoatClientInitializer;
import it.unimi.dsi.fastutil.Pair;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.function.Supplier;
import net.minecraft.client.model.BoatModel;
import net.minecraft.client.model.ChestBoatModel;
import net.minecraft.client.model.ChestRaftModel;
import net.minecraft.client.model.RaftModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public final class TerraformBoatClientHelper {
    private TerraformBoatClientHelper() {
    }

    private static ResourceLocation getLayerId(ResourceLocation boatId, boolean raft, boolean chest) {
        String prefix = raft ? (chest ? "chest_raft/" : "raft/") : (chest ? "chest_boat/" : "boat/");
        return new ResourceLocation(boatId.m_135827_(), prefix + boatId.m_135815_());
    }

    public static ModelLayerLocation getLayer(ResourceLocation boatId, boolean raft, boolean chest) {
        return new ModelLayerLocation(TerraformBoatClientHelper.getLayerId(boatId, raft, chest), "main");
    }

    private static Supplier<LayerDefinition> getTexturedModelDataProvider(boolean raft, boolean chest) {
        if (raft) {
            return chest ? ChestRaftModel::m_246875_ : RaftModel::m_247376_;
        }
        return chest ? ChestBoatModel::m_247175_ : BoatModel::m_246613_;
    }

    public static void registerModelLayer(ResourceLocation boatId, boolean raft, boolean chest) {
        TerraformBoatClientInitializer.SUPPLIER_MAP.computeIfAbsent(boatId, b -> new Object2ObjectOpenHashMap()).put(chest, Pair.of((Object)raft, TerraformBoatClientHelper.getTexturedModelDataProvider(raft, chest)));
    }

    public static void registerModelLayers(ResourceLocation boatId, boolean raft) {
        TerraformBoatClientHelper.registerModelLayer(boatId, raft, false);
        TerraformBoatClientHelper.registerModelLayer(boatId, raft, true);
    }
}

