/*
 * Decompiled with CFR 0.152.
 */
package com.terraformersmc.terraform.wood.block;

import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DiggerItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class BareSmallLogBlock
extends Block
implements SimpleWaterloggedBlock {
    public static final BooleanProperty UP = BlockStateProperties.f_61366_;
    public static final BooleanProperty DOWN = BlockStateProperties.f_61367_;
    public static final BooleanProperty NORTH = BlockStateProperties.f_61368_;
    public static final BooleanProperty EAST = BlockStateProperties.f_61369_;
    public static final BooleanProperty SOUTH = BlockStateProperties.f_61370_;
    public static final BooleanProperty WEST = BlockStateProperties.f_61371_;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    private static final int UP_MASK = 1 << Direction.UP.ordinal();
    private static final int DOWN_MASK = 1 << Direction.DOWN.ordinal();
    private static final int NORTH_MASK = 1 << Direction.NORTH.ordinal();
    private static final int EAST_MASK = 1 << Direction.EAST.ordinal();
    private static final int SOUTH_MASK = 1 << Direction.SOUTH.ordinal();
    private static final int WEST_MASK = 1 << Direction.WEST.ordinal();
    protected final VoxelShape[] collisionShapes;
    protected final VoxelShape[] boundingShapes;
    private final Object2IntMap<BlockState> SHAPE_INDEX_CACHE = new Object2IntOpenHashMap();
    private final Supplier<Block> stripped;

    public BareSmallLogBlock(Supplier<Block> stripped, BlockBehaviour.Properties settings) {
        super(settings);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)UP, (Comparable)Boolean.valueOf(false))).m_61124_((Property)DOWN, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WEST, (Comparable)Boolean.valueOf(false))).m_61124_((Property)EAST, (Comparable)Boolean.valueOf(false))).m_61124_((Property)NORTH, (Comparable)Boolean.valueOf(false))).m_61124_((Property)SOUTH, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
        this.collisionShapes = this.createShapes(5.0);
        this.boundingShapes = this.createShapes(5.0);
        this.stripped = stripped;
    }

    private int getShapeIndex(BlockState requested) {
        return this.SHAPE_INDEX_CACHE.computeIntIfAbsent((Object)requested, state -> {
            int mask = 0;
            if (((Boolean)state.m_61143_((Property)UP)).booleanValue()) {
                mask |= UP_MASK;
            }
            if (((Boolean)state.m_61143_((Property)DOWN)).booleanValue()) {
                mask |= DOWN_MASK;
            }
            if (((Boolean)state.m_61143_((Property)NORTH)).booleanValue()) {
                mask |= NORTH_MASK;
            }
            if (((Boolean)state.m_61143_((Property)EAST)).booleanValue()) {
                mask |= EAST_MASK;
            }
            if (((Boolean)state.m_61143_((Property)SOUTH)).booleanValue()) {
                mask |= SOUTH_MASK;
            }
            if (((Boolean)state.m_61143_((Property)WEST)).booleanValue()) {
                mask |= WEST_MASK;
            }
            return mask;
        });
    }

    public VoxelShape[] createShapes(double radius) {
        double lower = 8.0 - radius;
        double upper = 8.0 + radius;
        VoxelShape center = Block.m_49796_((double)lower, (double)lower, (double)lower, (double)upper, (double)upper, (double)upper);
        VoxelShape down = Block.m_49796_((double)lower, (double)0.0, (double)lower, (double)upper, (double)lower, (double)upper);
        VoxelShape up = Block.m_49796_((double)lower, (double)upper, (double)lower, (double)upper, (double)16.0, (double)upper);
        VoxelShape north = Block.m_49796_((double)lower, (double)lower, (double)0.0, (double)upper, (double)upper, (double)lower);
        VoxelShape south = Block.m_49796_((double)lower, (double)lower, (double)upper, (double)upper, (double)upper, (double)16.0);
        VoxelShape west = Block.m_49796_((double)0.0, (double)lower, (double)lower, (double)lower, (double)upper, (double)upper);
        VoxelShape east = Block.m_49796_((double)upper, (double)lower, (double)lower, (double)16.0, (double)upper, (double)upper);
        VoxelShape[] shapes = new VoxelShape[64];
        for (int i = 0; i < 64; ++i) {
            VoxelShape shape = center;
            if ((i & DOWN_MASK) != 0) {
                shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)down);
            }
            if ((i & UP_MASK) != 0) {
                shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)up);
            }
            if ((i & NORTH_MASK) != 0) {
                shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)north);
            }
            if ((i & SOUTH_MASK) != 0) {
                shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)south);
            }
            if ((i & WEST_MASK) != 0) {
                shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)west);
            }
            if ((i & EAST_MASK) != 0) {
                shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)east);
            }
            shapes[i] = shape;
        }
        return shapes;
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult result) {
        DiggerItem tool;
        ItemStack held = player.m_21120_(hand);
        if (this.stripped != null && held.m_41720_() instanceof DiggerItem && (tool = (DiggerItem)held.m_41720_()).m_8102_(held, state) > 1.0f) {
            world.m_5594_(player, pos, SoundEvents.f_11688_, SoundSource.BLOCKS, 1.0f, 1.0f);
            if (!world.f_46443_) {
                BlockState target = (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stripped.get().m_49966_().m_61124_((Property)UP, (Comparable)((Boolean)state.m_61143_((Property)UP)))).m_61124_((Property)DOWN, (Comparable)((Boolean)state.m_61143_((Property)DOWN)))).m_61124_((Property)NORTH, (Comparable)((Boolean)state.m_61143_((Property)NORTH)))).m_61124_((Property)SOUTH, (Comparable)((Boolean)state.m_61143_((Property)SOUTH)))).m_61124_((Property)EAST, (Comparable)((Boolean)state.m_61143_((Property)EAST)))).m_61124_((Property)WEST, (Comparable)((Boolean)state.m_61143_((Property)WEST)))).m_61124_((Property)WATERLOGGED, (Comparable)((Boolean)state.m_61143_((Property)WATERLOGGED)));
                world.m_46597_(pos, target);
                held.m_41622_(1, (LivingEntity)player, consumedPlayer -> consumedPlayer.m_21190_(hand));
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.FAIL;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{UP, DOWN, NORTH, SOUTH, EAST, WEST, WATERLOGGED});
    }

    private boolean shouldConnectTo(BlockState state, boolean solid) {
        Block block = state.m_60734_();
        return solid || block instanceof BareSmallLogBlock;
    }

    public void m_6402_(Level world, BlockPos pos, BlockState state, LivingEntity entity, ItemStack stack) {
        super.m_6402_(world, pos, state, entity, stack);
        for (Direction direction : Direction.values()) {
            BlockPos offsetPos = pos.m_121945_(direction);
            BlockState offsetState = world.m_8055_(offsetPos);
            if (!(offsetState.m_60734_() instanceof BareSmallLogBlock)) continue;
            world.m_46597_(offsetPos, this.getNeighborUpdateState(offsetState, direction.m_122424_(), state, (LevelAccessor)world, offsetPos, pos));
        }
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        Level world = context.m_43725_();
        BlockPos pos = context.m_8083_();
        FluidState fluid = context.m_43725_().m_6425_(context.m_8083_());
        if (context.m_43723_() == null) {
            return fluid.m_76152_().equals(Fluids.f_76193_) ? (BlockState)this.m_49966_().m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(true)) : this.m_49966_();
        }
        BlockPos upPos = pos.m_7494_();
        BlockPos downPos = pos.m_7495_();
        BlockPos northPos = pos.m_122012_();
        BlockPos eastPos = pos.m_122029_();
        BlockPos southPos = pos.m_122019_();
        BlockPos westPos = pos.m_122024_();
        BlockState upState = world.m_8055_(upPos);
        BlockState downState = world.m_8055_(downPos);
        BlockState northState = world.m_8055_(northPos);
        BlockState eastState = world.m_8055_(eastPos);
        BlockState southState = world.m_8055_(southPos);
        BlockState westState = world.m_8055_(westPos);
        boolean up = this.shouldConnectTo(upState, upState.m_60783_((BlockGetter)world, upPos, Direction.UP));
        boolean down = this.shouldConnectTo(downState, downState.m_60783_((BlockGetter)world, downPos, Direction.DOWN));
        boolean north = this.shouldConnectTo(northState, northState.m_60783_((BlockGetter)world, northPos, Direction.SOUTH));
        boolean east = this.shouldConnectTo(eastState, eastState.m_60783_((BlockGetter)world, eastPos, Direction.WEST));
        boolean south = this.shouldConnectTo(southState, southState.m_60783_((BlockGetter)world, southPos, Direction.NORTH));
        boolean west = this.shouldConnectTo(westState, westState.m_60783_((BlockGetter)world, westPos, Direction.EAST));
        return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)UP, (Comparable)Boolean.valueOf(up))).m_61124_((Property)DOWN, (Comparable)Boolean.valueOf(down))).m_61124_((Property)NORTH, (Comparable)Boolean.valueOf(north))).m_61124_((Property)EAST, (Comparable)Boolean.valueOf(east))).m_61124_((Property)SOUTH, (Comparable)Boolean.valueOf(south))).m_61124_((Property)WEST, (Comparable)Boolean.valueOf(west))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluid.m_76152_() == Fluids.f_76193_));
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        switch (rotation) {
            case CLOCKWISE_180: {
                return (BlockState)((BlockState)((BlockState)((BlockState)state.m_61124_((Property)NORTH, (Comparable)((Boolean)state.m_61143_((Property)SOUTH)))).m_61124_((Property)EAST, (Comparable)((Boolean)state.m_61143_((Property)WEST)))).m_61124_((Property)SOUTH, (Comparable)((Boolean)state.m_61143_((Property)NORTH)))).m_61124_((Property)WEST, (Comparable)((Boolean)state.m_61143_((Property)EAST)));
            }
            case COUNTERCLOCKWISE_90: {
                return (BlockState)((BlockState)((BlockState)((BlockState)state.m_61124_((Property)NORTH, (Comparable)((Boolean)state.m_61143_((Property)EAST)))).m_61124_((Property)EAST, (Comparable)((Boolean)state.m_61143_((Property)SOUTH)))).m_61124_((Property)SOUTH, (Comparable)((Boolean)state.m_61143_((Property)WEST)))).m_61124_((Property)WEST, (Comparable)((Boolean)state.m_61143_((Property)NORTH)));
            }
            case CLOCKWISE_90: {
                return (BlockState)((BlockState)((BlockState)((BlockState)state.m_61124_((Property)NORTH, (Comparable)((Boolean)state.m_61143_((Property)WEST)))).m_61124_((Property)EAST, (Comparable)((Boolean)state.m_61143_((Property)NORTH)))).m_61124_((Property)SOUTH, (Comparable)((Boolean)state.m_61143_((Property)EAST)))).m_61124_((Property)WEST, (Comparable)((Boolean)state.m_61143_((Property)SOUTH)));
            }
        }
        return state;
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        switch (mirror) {
            case LEFT_RIGHT: {
                return (BlockState)((BlockState)state.m_61124_((Property)NORTH, (Comparable)((Boolean)state.m_61143_((Property)SOUTH)))).m_61124_((Property)SOUTH, (Comparable)((Boolean)state.m_61143_((Property)NORTH)));
            }
            case FRONT_BACK: {
                return (BlockState)((BlockState)state.m_61124_((Property)EAST, (Comparable)((Boolean)state.m_61143_((Property)WEST)))).m_61124_((Property)WEST, (Comparable)((Boolean)state.m_61143_((Property)EAST)));
            }
        }
        return super.m_6943_(state, mirror);
    }

    public boolean m_7357_(BlockState state, BlockGetter view, BlockPos pos, PathComputationType blockPlacementEnvironment_1) {
        return false;
    }

    public BlockState getNeighborUpdateState(BlockState state, Direction fromDirection, BlockState neighbor, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            world.m_186469_(pos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)world));
        }
        boolean up = fromDirection == Direction.UP && this.shouldConnectTo(neighbor, neighbor.m_60783_((BlockGetter)world, neighborPos, Direction.DOWN)) || (Boolean)state.m_61143_((Property)UP) != false;
        boolean down = fromDirection == Direction.DOWN && this.shouldConnectTo(neighbor, neighbor.m_60783_((BlockGetter)world, neighborPos, Direction.UP)) || (Boolean)state.m_61143_((Property)DOWN) != false;
        boolean north = fromDirection == Direction.NORTH && this.shouldConnectTo(neighbor, neighbor.m_60783_((BlockGetter)world, neighborPos, Direction.SOUTH)) || (Boolean)state.m_61143_((Property)NORTH) != false;
        boolean east = fromDirection == Direction.EAST && this.shouldConnectTo(neighbor, neighbor.m_60783_((BlockGetter)world, neighborPos, Direction.WEST)) || (Boolean)state.m_61143_((Property)EAST) != false;
        boolean south = fromDirection == Direction.SOUTH && this.shouldConnectTo(neighbor, neighbor.m_60783_((BlockGetter)world, neighborPos, Direction.NORTH)) || (Boolean)state.m_61143_((Property)SOUTH) != false;
        boolean west = fromDirection == Direction.WEST && this.shouldConnectTo(neighbor, neighbor.m_60783_((BlockGetter)world, neighborPos, Direction.EAST)) || (Boolean)state.m_61143_((Property)WEST) != false;
        return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)state.m_61124_((Property)UP, (Comparable)Boolean.valueOf(up))).m_61124_((Property)DOWN, (Comparable)Boolean.valueOf(down))).m_61124_((Property)NORTH, (Comparable)Boolean.valueOf(north))).m_61124_((Property)EAST, (Comparable)Boolean.valueOf(east))).m_61124_((Property)SOUTH, (Comparable)Boolean.valueOf(south))).m_61124_((Property)WEST, (Comparable)Boolean.valueOf(west));
    }

    public boolean m_7420_(BlockState state, BlockGetter view, BlockPos pos) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) == false;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter view, BlockPos pos, CollisionContext context) {
        return this.boundingShapes[this.getShapeIndex(state)];
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter view, BlockPos pos, CollisionContext context) {
        return this.collisionShapes[this.getShapeIndex(state)];
    }
}

