/*
 * Decompiled with CFR 0.152.
 */
package com.terraformersmc.terraform.boat.api.item;

import com.terraformersmc.terraform.boat.api.TerraformBoatType;
import com.terraformersmc.terraform.boat.impl.item.TerraformBoatDispenserBehavior;
import com.terraformersmc.terraform.boat.impl.item.TerraformBoatItem;
import java.util.function.Supplier;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraftforge.registries.ForgeRegistries;

public final class TerraformBoatItemHelper {
    private static final CreativeModeTab DEFAULT_ITEM_GROUP = CreativeModeTab.f_40752_;

    private TerraformBoatItemHelper() {
    }

    public static Item registerBoatItem(ResourceLocation id, Supplier<TerraformBoatType> boatSupplier, boolean chest) {
        return TerraformBoatItemHelper.registerBoatItem(id, boatSupplier, chest, DEFAULT_ITEM_GROUP);
    }

    public static Item registerBoatItem(ResourceLocation id, Supplier<TerraformBoatType> boatSupplier, boolean chest, CreativeModeTab group) {
        return TerraformBoatItemHelper.registerBoatItem(id, boatSupplier, chest, new Item.Properties().m_41487_(1).m_41491_(group));
    }

    public static Item registerBoatItem(ResourceLocation id, Supplier<TerraformBoatType> boatSupplier, boolean chest, Item.Properties settings) {
        TerraformBoatItem item = new TerraformBoatItem(boatSupplier, chest, settings);
        ForgeRegistries.ITEMS.register(id, (Object)item);
        TerraformBoatItemHelper.registerBoatDispenserBehavior((ItemLike)item, boatSupplier, chest);
        return item;
    }

    public static void registerBoatDispenserBehavior(ItemLike item, Supplier<TerraformBoatType> boatSupplier, boolean chest) {
        DispenserBlock.m_52672_((ItemLike)item, (DispenseItemBehavior)new TerraformBoatDispenserBehavior(boatSupplier, chest));
    }
}

