/*
 * Decompiled with CFR 0.152.
 */
package com.terraformersmc.terraform.boat.api.client;

import com.terraformersmc.terraform.boat.impl.client.TerraformBoatClientInitializer;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import net.minecraft.client.model.BoatModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public final class TerraformBoatClientHelper {
    private TerraformBoatClientHelper() {
    }

    private static ResourceLocation getLayerId(ResourceLocation boatId, boolean chest) {
        String prefix = chest ? "chest_boat/" : "boat/";
        return new ResourceLocation(boatId.m_135827_(), prefix + boatId.m_135815_());
    }

    public static ModelLayerLocation getLayer(ResourceLocation boatId, boolean chest) {
        return new ModelLayerLocation(TerraformBoatClientHelper.getLayerId(boatId, chest), "main");
    }

    public static void registerModelLayer(ResourceLocation boatId, boolean chest) {
        TerraformBoatClientInitializer.SUPPLIER_MAP.computeIfAbsent(boatId, b -> new Object2ObjectOpenHashMap()).put(chest, () -> BoatModel.m_233347_((boolean)chest));
    }

    public static void registerModelLayers(ResourceLocation boatId) {
        TerraformBoatClientHelper.registerModelLayer(boatId, false);
        TerraformBoatClientHelper.registerModelLayer(boatId, true);
    }
}

