/*
 * Decompiled with CFR 0.152.
 */
package com.terraformersmc.terraform.utils;

import com.terraformersmc.terraform.utils.mixin.AbstractBlockAccessor;
import com.terraformersmc.terraform.utils.mixin.AbstractBlockSettingsAccessor;
import java.util.function.ToIntFunction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.MapColor;

public class TerraformBlockSettings
extends BlockBehaviour.Properties {
    protected TerraformBlockSettings() {
    }

    protected TerraformBlockSettings(BlockBehaviour.Properties settings) {
        this();
        AbstractBlockSettingsAccessor thisAccessor = (AbstractBlockSettingsAccessor)((Object)this);
        AbstractBlockSettingsAccessor otherAccessor = (AbstractBlockSettingsAccessor)settings;
        this.hardness(otherAccessor.getHardness());
        this.resistance(otherAccessor.getResistance());
        this.collidable(otherAccessor.getCollidable());
        thisAccessor.setRandomTicks(otherAccessor.getRandomTicks());
        this.luminance(otherAccessor.getLuminance());
        thisAccessor.setMapColorProvider(otherAccessor.getMapColorProvider());
        this.sounds(otherAccessor.getSoundGroup());
        this.slipperiness(otherAccessor.getSlipperiness());
        this.velocityMultiplier(otherAccessor.getVelocityMultiplier());
        this.jumpVelocityMultiplier(otherAccessor.getJumpVelocityMultiplier());
        thisAccessor.setDynamicBounds(otherAccessor.getDynamicBounds());
        thisAccessor.setOpaque(otherAccessor.getOpaque());
        thisAccessor.setIsAir(otherAccessor.getIsAir());
        thisAccessor.setToolRequired(otherAccessor.isToolRequired());
        this.allowsSpawning(otherAccessor.getAllowsSpawningPredicate());
        this.solidBlock(otherAccessor.getSolidBlockPredicate());
        this.suffocates(otherAccessor.getSuffocationPredicate());
        this.blockVision(otherAccessor.getBlockVisionPredicate());
        this.postProcess(otherAccessor.getPostProcessPredicate());
        this.emissiveLighting(otherAccessor.getEmissiveLightingPredicate());
    }

    public static TerraformBlockSettings create() {
        return new TerraformBlockSettings();
    }

    public static TerraformBlockSettings copyOf(BlockBehaviour block) {
        return new TerraformBlockSettings(((AbstractBlockAccessor)block).getSettings());
    }

    public static TerraformBlockSettings copyOf(BlockBehaviour.Properties settings) {
        return new TerraformBlockSettings(settings);
    }

    public TerraformBlockSettings noCollision() {
        super.m_60910_();
        return this;
    }

    public TerraformBlockSettings nonOpaque() {
        super.m_60955_();
        return this;
    }

    public TerraformBlockSettings slipperiness(float value) {
        super.m_60911_(value);
        return this;
    }

    public TerraformBlockSettings velocityMultiplier(float velocityMultiplier) {
        super.m_60956_(velocityMultiplier);
        return this;
    }

    public TerraformBlockSettings jumpVelocityMultiplier(float jumpVelocityMultiplier) {
        super.m_60967_(jumpVelocityMultiplier);
        return this;
    }

    public TerraformBlockSettings sounds(SoundType group) {
        super.m_60918_(group);
        return this;
    }

    public TerraformBlockSettings luminance(ToIntFunction<BlockState> luminanceFunction) {
        super.m_60953_(luminanceFunction);
        return this;
    }

    public TerraformBlockSettings strength(float hardness, float resistance) {
        super.m_60913_(hardness, resistance);
        return this;
    }

    public TerraformBlockSettings breakInstantly() {
        super.m_60966_();
        return this;
    }

    public TerraformBlockSettings strength(float strength) {
        super.m_60978_(strength);
        return this;
    }

    public TerraformBlockSettings ticksRandomly() {
        super.m_60977_();
        return this;
    }

    public TerraformBlockSettings dynamicBounds() {
        super.m_60988_();
        return this;
    }

    public TerraformBlockSettings dropsNothing() {
        super.m_222994_();
        return this;
    }

    public TerraformBlockSettings dropsLike(Block block) {
        super.m_60916_(block);
        return this;
    }

    public TerraformBlockSettings air() {
        super.m_60996_();
        return this;
    }

    public TerraformBlockSettings allowsSpawning(BlockBehaviour.StateArgumentPredicate<EntityType<?>> predicate) {
        super.m_60922_(predicate);
        return this;
    }

    public TerraformBlockSettings solidBlock(BlockBehaviour.StatePredicate predicate) {
        super.m_60924_(predicate);
        return this;
    }

    public TerraformBlockSettings suffocates(BlockBehaviour.StatePredicate predicate) {
        super.m_60960_(predicate);
        return this;
    }

    public TerraformBlockSettings blockVision(BlockBehaviour.StatePredicate predicate) {
        super.m_60971_(predicate);
        return this;
    }

    public TerraformBlockSettings postProcess(BlockBehaviour.StatePredicate predicate) {
        super.m_60982_(predicate);
        return this;
    }

    public TerraformBlockSettings emissiveLighting(BlockBehaviour.StatePredicate predicate) {
        super.m_60991_(predicate);
        return this;
    }

    public TerraformBlockSettings luminance(int luminance) {
        this.luminance(ignored -> luminance);
        return this;
    }

    public TerraformBlockSettings hardness(float hardness) {
        ((AbstractBlockSettingsAccessor)((Object)this)).setHardness(hardness);
        return this;
    }

    public TerraformBlockSettings resistance(float resistance) {
        ((AbstractBlockSettingsAccessor)((Object)this)).setResistance(Math.max(0.0f, resistance));
        return this;
    }

    public TerraformBlockSettings drops(ResourceLocation dropTableId) {
        ((AbstractBlockSettingsAccessor)((Object)this)).setLootTableId(dropTableId);
        return this;
    }

    public TerraformBlockSettings requiresTool() {
        super.m_60999_();
        return this;
    }

    public TerraformBlockSettings mapColor(MapColor color) {
        ((AbstractBlockSettingsAccessor)((Object)this)).setMapColorProvider(ignored -> color);
        return this;
    }

    public TerraformBlockSettings mapColor(DyeColor color) {
        return this.mapColor(color.m_284406_());
    }

    public TerraformBlockSettings collidable(boolean collidable) {
        ((AbstractBlockSettingsAccessor)((Object)this)).setCollidable(collidable);
        return this;
    }
}

