/*
 * Decompiled with CFR 0.152.
 */
package com.terraformersmc.terraform.tree.merchant;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.level.ItemLike;
import org.apache.commons.lang3.ArrayUtils;

public final class TerraformSaplingTradeHelper {
    private TerraformSaplingTradeHelper() {
    }

    public static void registerWanderingTraderSaplingTrades(ItemLike ... saplings) {
        TerraformSaplingTradeHelper.registerWanderingTraderOffers(1, factories -> {
            for (ItemLike sapling : saplings) {
                factories.add(new SellSaplingFactory(sapling));
            }
        });
    }

    public static synchronized void registerWanderingTraderOffers(int level, Consumer<List<VillagerTrades.ItemListing>> factory) {
        TerraformSaplingTradeHelper.registerOffers((Int2ObjectMap<VillagerTrades.ItemListing[]>)VillagerTrades.f_35628_, level, factory);
    }

    private static void registerOffers(Int2ObjectMap<VillagerTrades.ItemListing[]> leveledTradeMap, int level, Consumer<List<VillagerTrades.ItemListing>> factory) {
        ArrayList list = new ArrayList();
        factory.accept(list);
        Object[] originalEntries = (VillagerTrades.ItemListing[])leveledTradeMap.computeIfAbsent(level, key -> new VillagerTrades.ItemListing[0]);
        Object[] addedEntries = list.toArray(new VillagerTrades.ItemListing[0]);
        VillagerTrades.ItemListing[] allEntries = (VillagerTrades.ItemListing[])ArrayUtils.addAll((Object[])originalEntries, (Object[])addedEntries);
        leveledTradeMap.put(level, (Object)allEntries);
    }

    private static class SellSaplingFactory
    implements VillagerTrades.ItemListing {
        private final ItemStack sapling;

        public SellSaplingFactory(ItemLike sapling) {
            this.sapling = new ItemStack(sapling);
        }

        public MerchantOffer m_213663_(Entity entity, RandomSource random) {
            return new MerchantOffer(new ItemStack((ItemLike)Items.f_42616_, 5), this.sapling, 8, 1, 0.05f);
        }
    }
}

