/*
 * Decompiled with CFR 0.152.
 */
package com.terraformersmc.terraform.shapes.api;

import com.terraformersmc.terraform.shapes.api.Position;
import org.joml.Quaterniondc;
import org.joml.Quaternionfc;

public interface Quaternion {
    public static Quaternion of(final double ofW, final double ofI, final double ofJ, final double ofK) {
        return new Quaternion(){
            private double w;
            private double i;
            private double j;
            private double k;
            {
                this.w = ofW;
                this.i = ofI;
                this.j = ofJ;
                this.k = ofK;
            }

            @Override
            public double getW() {
                return this.w;
            }

            @Override
            public double getI() {
                return this.i;
            }

            @Override
            public double getJ() {
                return this.j;
            }

            @Override
            public double getK() {
                return this.k;
            }

            @Override
            public void setW(double w) {
                this.w = w;
            }

            @Override
            public void setI(double i) {
                this.i = i;
            }

            @Override
            public void setJ(double j) {
                this.j = j;
            }

            @Override
            public void setK(double k) {
                this.k = k;
            }
        };
    }

    public static Quaternion of(double x, double y, double z, boolean degrees) {
        if (degrees) {
            x *= 0.01745329238474369;
            y *= 0.01745329238474369;
            z *= 0.01745329238474369;
        }
        double f = Math.sin(0.5 * x);
        double g = Math.cos(0.5 * x);
        double h = Math.sin(0.5 * y);
        double i = Math.cos(0.5 * y);
        double j = Math.sin(0.5 * z);
        double k = Math.cos(0.5 * z);
        double xNew = f * i * k + g * h * j;
        double yNew = g * h * k - f * i * j;
        double zNew = f * h * k + g * i * j;
        double wNew = g * i * k - f * h * j;
        return Quaternion.of(wNew, xNew, yNew, zNew);
    }

    public static Quaternion of(Quaterniondc q) {
        return Quaternion.of(q.w(), q.x(), q.y(), q.z());
    }

    public static Quaternion of(Quaternionfc q) {
        return Quaternion.of((double)q.w(), (double)q.x(), (double)q.y(), q.z());
    }

    public static Quaternion of(Quaternion q) {
        return Quaternion.of(q.getW(), q.getI(), q.getJ(), q.getK());
    }

    default public Quaternion copy() {
        return Quaternion.of(this);
    }

    public double getW();

    public double getI();

    public double getJ();

    public double getK();

    public void setW(double var1);

    public void setI(double var1);

    public void setJ(double var1);

    public void setK(double var1);

    default public Quaternion multiply(Quaternion multiplier) {
        double newW = this.getW() * multiplier.getW() - this.getI() * multiplier.getI() - this.getJ() * multiplier.getJ() - this.getK() * multiplier.getK();
        double newI = this.getW() * multiplier.getI() + this.getI() * multiplier.getW() + this.getJ() * multiplier.getK() - this.getK() * multiplier.getJ();
        double newJ = this.getW() * multiplier.getJ() - this.getI() * multiplier.getK() + this.getJ() * multiplier.getW() + this.getK() * multiplier.getI();
        double newK = this.getW() * multiplier.getK() + this.getI() * multiplier.getJ() - this.getJ() * multiplier.getI() + this.getK() * multiplier.getW();
        this.setW(newW);
        this.setI(newI);
        this.setJ(newJ);
        this.setK(newK);
        return this;
    }

    default public Quaternion conjugate() {
        return Quaternion.of(this.getW(), -this.getI(), -this.getJ(), -this.getK());
    }

    default public Position toPosition() {
        return Position.of(this.getI(), this.getJ(), this.getK());
    }

    public static Quaternion of(Position pos) {
        return Quaternion.of(0.0, pos.getX(), pos.getY(), pos.getZ());
    }
}

