/*
 * Decompiled with CFR 0.152.
 */
package com.samsthenerd.monthofswords.items;

import com.samsthenerd.monthofswords.registry.SwordsModComponents;
import com.samsthenerd.monthofswords.utils.Description;
import com.samsthenerd.monthofswords.utils.ItemDescriptions;
import dev.architectury.platform.Platform;
import dev.architectury.utils.Env;
import java.util.List;
import java.util.Optional;
import java.util.function.UnaryOperator;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;

public class SwordtemberItem
extends SwordItem {
    public SwordtemberItem(Tier toolMats, Item.Properties itemSettings) {
        super(toolMats, itemSettings);
    }

    public UnaryOperator<Style> getSwordTooltipStyleModifier() {
        return style -> style.withColor(ChatFormatting.GRAY);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag type) {
        Optional<Description> descOpt;
        if (Platform.getEnvironment() != Env.SERVER && (descOpt = ItemDescriptions.getItemDescription(stack.getItem())).isPresent()) {
            Description desc = descOpt.get();
            tooltip.addAll(desc.getTooltipFull(stack, context, type));
        }
        super.appendHoverText(stack, context, tooltip, type);
    }

    public Optional<TooltipComponent> getTooltipImage(ItemStack stack) {
        return Optional.ofNullable((Description.DescriptionItemComponent)stack.get(SwordsModComponents.ITEM_DESCRIPTION_DATA)).filter(Description.DescriptionItemComponent::hintMode).flatMap(Description.DescriptionItemComponent::ttData);
    }
}

