/*
 * Decompiled with CFR 0.152.
 */
package com.samsthenerd.monthofswords.items;

import com.samsthenerd.monthofswords.items.ClassyToolMaterial;
import com.samsthenerd.monthofswords.items.SwordtemberItem;
import java.util.function.UnaryOperator;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.Block;

public class FloralSwordItem
extends SwordtemberItem {
    private static RandomSource random = RandomSource.createNewThreadLocalInstance();
    public static final ClassyToolMaterial FLORAL_MATERIAL = new ClassyToolMaterial(150, 8.0f, 1.0f, (TagKey<Block>)BlockTags.INCORRECT_FOR_WOODEN_TOOL, 18, () -> Ingredient.EMPTY);

    public FloralSwordItem(Item.Properties itemSettings) {
        super(FLORAL_MATERIAL, itemSettings.attributes(SwordItem.createAttributes((Tier)FLORAL_MATERIAL, (int)3, (float)-2.4f)));
    }

    @Override
    public UnaryOperator<Style> getSwordTooltipStyleModifier() {
        return style -> style.withColor(ChatFormatting.GREEN);
    }

    public void inventoryTick(ItemStack stack, Level world, Entity entity, int slot, boolean selected) {
        boolean probSaysYes;
        int skyLight = world.getLightEngine().getLayerListener(LightLayer.SKY).getLightValue(entity.blockPosition());
        boolean bl = probSaysYes = entity.tickCount % 100 == 0;
        if (world instanceof ServerLevel) {
            ServerLevel sWorld = (ServerLevel)world;
            if (stack.getDamageValue() > 0 && slot >= 0 && slot < 9 && skyLight > 7 && sWorld.isDay() && probSaysYes) {
                stack.setDamageValue(Math.max(stack.getDamageValue() - 10, 0));
            }
        }
    }
}

