/*
 * Decompiled with CFR 0.152.
 */
package com.samsthenerd.monthofswords.items;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.samsthenerd.monthofswords.items.ClassyToolMaterial;
import com.samsthenerd.monthofswords.items.SwordtemberItem;
import com.samsthenerd.monthofswords.registry.SwordsModComponents;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.core.UUIDUtil;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;

public class CrystalSwordItem
extends SwordtemberItem {
    public static final Tier AMETHYST_CRYSTAL_MATERIAL = new ClassyToolMaterial(500, 5.0f, 2.0f, (TagKey<Block>)BlockTags.INCORRECT_FOR_IRON_TOOL, 16, () -> Ingredient.of((ItemLike[])new ItemLike[]{Items.COPPER_INGOT}));

    public CrystalSwordItem(Item.Properties itemSettings) {
        super(AMETHYST_CRYSTAL_MATERIAL, itemSettings.attributes(SwordItem.createAttributes((Tier)AMETHYST_CRYSTAL_MATERIAL, (int)3, (float)-2.4f)));
    }

    @Override
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag type) {
        Optional<ResonatingComponent> resCompOpt = Optional.ofNullable((ResonatingComponent)stack.get(SwordsModComponents.RESONANCE_DATA));
        resCompOpt.flatMap(ResonatingComponent::getDamageStateText).ifPresent(tooltip::add);
        super.appendHoverText(stack, context, tooltip, type);
    }

    public float getAttackDamageBonus(Entity target, float baseAttackDamage, DamageSource damageSource) {
        ItemStack stack = damageSource.getWeaponItem();
        float baseDamage = super.getAttackDamageBonus(target, baseAttackDamage, damageSource);
        if (stack == null || stack.isEmpty()) {
            return baseDamage;
        }
        ResonatingComponent resComp = (ResonatingComponent)stack.get(SwordsModComponents.RESONANCE_DATA);
        if (resComp == null) {
            return baseDamage;
        }
        if (EntityType.getKey((EntityType)target.getType()).equals((Object)resComp.entityType)) {
            return resComp.extraDamage + baseDamage;
        }
        return baseDamage;
    }

    public void postHurtEnemy(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        Optional<ResonatingComponent> resCompOpt = Optional.ofNullable((ResonatingComponent)stack.get(SwordsModComponents.RESONANCE_DATA));
        ResourceLocation targetType = EntityType.getKey((EntityType)target.getType());
        ResonatingComponent resComp = resCompOpt.map(resCompOld -> {
            float newDamage = resCompOld.extraDamage;
            newDamage = resCompOld.lastHit.equals(target.getUUID()) ? (newDamage += 0.05f) : (resCompOld.entityType.equals((Object)targetType) ? (newDamage += 0.5f) : 0.5f);
            newDamage = (float)Math.round(newDamage * 1000.0f) / 1000.0f;
            return new ResonatingComponent(targetType, target.getUUID(), newDamage);
        }).orElse(new ResonatingComponent(targetType, target.getUUID(), 0.5f));
        stack.set(SwordsModComponents.RESONANCE_DATA, (Object)resComp);
        if (attacker instanceof ServerPlayer) {
            ServerPlayer sPlayer = (ServerPlayer)attacker;
            resComp.getDamageStateText().ifPresent(t -> sPlayer.displayClientMessage(t, true));
        }
        super.postHurtEnemy(stack, target, attacker);
    }

    public record ResonatingComponent(ResourceLocation entityType, UUID lastHit, float extraDamage) {
        public static final Codec<ResonatingComponent> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ResourceLocation.CODEC.fieldOf("entityType").forGetter(ResonatingComponent::entityType), (App)UUIDUtil.AUTHLIB_CODEC.fieldOf("lastHit").forGetter(ResonatingComponent::lastHit), (App)Codec.FLOAT.fieldOf("extraDamage").forGetter(ResonatingComponent::extraDamage)).apply((Applicative)instance, ResonatingComponent::new));
        public static final StreamCodec<? super RegistryFriendlyByteBuf, ResonatingComponent> PACKET_CODEC = StreamCodec.composite((StreamCodec)ResourceLocation.STREAM_CODEC, ResonatingComponent::entityType, (StreamCodec)UUIDUtil.STREAM_CODEC, ResonatingComponent::lastHit, (StreamCodec)ByteBufCodecs.FLOAT, ResonatingComponent::extraDamage, ResonatingComponent::new);

        public Optional<Component> getDamageStateText() {
            return BuiltInRegistries.ENTITY_TYPE.getOptional(this.entityType).map(entType -> entType.getDescription().copy().append(": " + (this.extraDamage == 0.0f ? "" : "+") + this.extraDamage).append(" ").append((Component)Component.translatable((String)"attribute.name.generic.attack_damage")).withStyle(new ChatFormatting[]{ChatFormatting.DARK_GREEN, ChatFormatting.ITALIC}));
        }
    }
}

