package com.samsthenerd.monthofswords.lucky;

import com.samsthenerd.monthofswords.SwordsMod;
import net.minecraft.commands.CommandResultCallback;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.FunctionInstantiationException;
import net.minecraft.commands.execution.ExecutionContext;
import net.minecraft.commands.functions.CommandFunction;
import net.minecraft.commands.functions.InstantiatedFunction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.ServerFunctionManager;
import net.minecraft.world.entity.LivingEntity;
import org.jetbrains.annotations.Nullable;

import java.util.List;
import java.util.UUID;

public interface DataLuckyFunction extends LuckyFunction{

    default int attack(LivingEntity target, LivingEntity attacker){
        MinecraftServer server = attacker.getServer();
        if(server == null) return 0; // this should never happen probably
        ServerFunctionManager funMan = server.getFunctions();
        CommandSourceStack source = attacker.createCommandSourceStack()
            .withSuppressedOutput()
            .withPermission(2); // can do most stuff, just not server management.
        CommandFunction<CommandSourceStack> command = getCommand(funMan);
        if(command == null) return 0;
        CompoundTag macroSubst = new CompoundTag();
        macroSubst.putString("lucky_target", target.getUUID().toString());
        macroSubst.putString("lucky_attacker", attacker.getUUID().toString());
        try{
            InstantiatedFunction<CommandSourceStack> procedure = command.instantiate(macroSubst, funMan.getDispatcher());
            Commands.executeCommandInContext(source, context -> ExecutionContext.queueInitialFunctionCall(context, procedure, source, CommandResultCallback.EMPTY));

        } catch (FunctionInstantiationException e) {
            SwordsMod.LOGGER.error("Lucky Function Macro Error: " + e);
            return 0;
        }
        return getItemDamage();
    }

    int getItemDamage();

    @Nullable
    CommandFunction<CommandSourceStack> getCommand(ServerFunctionManager funMan);

    default boolean fromDataDriven(){
        return true;
    }

    record DataIdLuckyFunction(ResourceLocation functionId, int rarityWeight, LuckyModifier modifier, Integer itemDamage) implements DataLuckyFunction{

        @Override
        public int getWeight(double luck){
            return modifier().modify(rarityWeight(), luck);
        }

        @Nullable
        @Override
        public CommandFunction<CommandSourceStack> getCommand(ServerFunctionManager funMan){
            return funMan.get(functionId()).orElse(null);
        }

        @Override
        public int getItemDamage(){
            return itemDamage();
        }
    }

    record DataCommandLuckyFunction(String command, ResourceLocation id, int rarityWeight, LuckyModifier modifier, Integer itemDamage) implements DataLuckyFunction{

        @Override
        public int getWeight(double luck){
            return modifier().modify(rarityWeight(), luck);
        }

        @Nullable
        @Override
        public CommandFunction<CommandSourceStack> getCommand(ServerFunctionManager funMan){
            ResourceLocation madeUpID = id.withPath(p -> p + "_internal_synthesized_lucky_inline_function" + UUID.randomUUID());
            return CommandFunction.fromLines(madeUpID,
                funMan.getDispatcher(),
                funMan.getGameLoopSender(),
                List.of(command())
            );
        }

        @Override
        public int getItemDamage(){
            return itemDamage();
        }
    }
}
