package com.samsthenerd.monthofswords.items;

import com.samsthenerd.monthofswords.SwordsMod;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.crafting.Ingredient;

public class WingSwordItem extends SwordtemberItem {
    public static final ClassyToolMaterial WING_MATERIAL = new ClassyToolMaterial(2031, 12f, 0.1f,
            BlockTags.INCORRECT_FOR_GOLD_TOOL, 22, () -> Ingredient.EMPTY);

    public WingSwordItem(Item.Properties itemSettings){
        super(WING_MATERIAL, itemSettings.attributes(
            SwordItem.createAttributes(WING_MATERIAL, -1, 0)
            .withModifierAdded(
                Attributes.ATTACK_KNOCKBACK,
                new AttributeModifier(SwordsMod.id("wing_sword_knockback"), 1f, AttributeModifier.Operation.ADD_VALUE),
                EquipmentSlotGroup.MAINHAND
                )
            ));
    }
}
