package com.samsthenerd.monthofswords.items;

import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.samsthenerd.monthofswords.registry.SwordsModComponents;
import com.samsthenerd.monthofswords.registry.SwordsModDataAttachments;
import com.samsthenerd.monthofswords.registry.SwordsModItems;
import com.samsthenerd.monthofswords.xplat.SwordsModXPlat;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.UUIDUtil;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;

public class SummonableSwordItem extends SwordtemberItem implements SwordActionHaverServer {

    public static final Tier SUMMONABLE_MATERIAL = new ClassyToolMaterial(100, 5f, 3f,
        BlockTags.INCORRECT_FOR_DIAMOND_TOOL, 15, () -> Ingredient.EMPTY);

    public SummonableSwordItem(Item.Properties itemSettings) {
        super(SUMMONABLE_MATERIAL, itemSettings.attributes(
            SwordItem.createAttributes(SUMMONABLE_MATERIAL, 3, -2.4f))
        );
    }

    @Override
    public void inventoryTick(ItemStack stack, Level world, Entity entity, int slot, boolean selected) {
        if(world.isClientSide()) return; // nothing on client
        var swordSscd = stack.get(SwordsModComponents.SUMMON_SWORD_DATA);
        if(swordSscd == null) return; // if the sword doesn't have stuff then it's prob just from creative mode or something and we ignore it
        if(!swordSscd.player.equals(entity.getUUID())){ // if the sword has the wrong owner then we trash it.
            stack.shrink(1);
            return;
        }
        // we have the right owner, now just check that it's latest so we can trash old swords.
        var optSD = SwordsModXPlat.getInstance().getEntityTarget(entity).getAttached(SwordsModDataAttachments.SUMMON_SWORD_DATA_ATTACHMENT_TYPE);
        if(optSD.isEmpty()) return; // owner has no data? that's probably wrong, ignore it.
        var attachSscd = optSD.get().stack().get(SwordsModComponents.SUMMON_SWORD_DATA);
        if(attachSscd == null) return; // owner has data but it's malformed? also probably wrong, ignore.
        // if it's not the latest sword remove it.
        if(!attachSscd.summonId().equals(swordSscd.summonId)){
            stack.shrink(1);
            return;
        }
    }

    public static void trySummonSword(Player player){

        var mainStack = player.getItemInHand(InteractionHand.MAIN_HAND);
//        var offStack = player.getStackInHand(Hand.OFF_HAND);
        if(!mainStack.isEmpty()) return;
        var optSD = SwordsModXPlat.getInstance().getEntityTarget(player).modifyAttached(SwordsModDataAttachments.SUMMON_SWORD_DATA_ATTACHMENT_TYPE,
            optSDOld -> optSDOld.map(SummonSwordData::withFreshUuid));
        if(optSD.isEmpty()) return;
        ItemStack stack = optSD.get().stack();
        if(stack.isEmpty()) return;
        player.setItemInHand(InteractionHand.MAIN_HAND, stack.copy());
//        player.giveItemStack(stack.copy());
    }

    @Override
    public boolean doSwordAction(Player player, ItemStack swordStack) {
        SwordsModXPlat.getInstance().getEntityTarget(player)
            .modifyAttached(SwordsModDataAttachments.SUMMON_SWORD_DATA_ATTACHMENT_TYPE, optSD -> optSD.map(sd -> sd.saveSwordInfo(swordStack)));
        swordStack.setCount(0);
        return true;
    }

    public record SummonSwordData(ItemStack stack){
        public static SummonSwordData getFreshData(Player player){
            UUID summonId = UUID.randomUUID();
            ItemStack sword = new ItemStack(SwordsModItems.SUMMONED_SWORD.get());
            sword.set(SwordsModComponents.SUMMON_SWORD_DATA, new SummonSwordComponentData(player.getUUID(), summonId));
            return new SummonSwordData(sword);
        }

        public SummonSwordData withFreshUuid(){
            SummonSwordComponentData sscd = stack.get(SwordsModComponents.SUMMON_SWORD_DATA);
            if(sscd == null) return this;
            var sscdNew = new SummonSwordComponentData(sscd.player, UUID.randomUUID());
            ItemStack newStack = stack.copy();
            newStack.set(SwordsModComponents.SUMMON_SWORD_DATA, sscdNew);
            return new SummonSwordData(newStack);
        }

        public SummonSwordData saveSwordInfo(ItemStack newSword){
            var newerSword = newSword.copy();
            newerSword.setDamageValue(0);
            newerSword.set(DataComponents.REPAIR_COST, 0);
            SummonSwordComponentData sscd = stack.get(SwordsModComponents.SUMMON_SWORD_DATA);
//            if(sscd == null) return this;
//            var sscdNew = new SummonSwordComponentData(sscd.player, UUID.randomUUID());
            newerSword.set(SwordsModComponents.SUMMON_SWORD_DATA, sscd);
            return new SummonSwordData(newerSword);
        }

        public static SummonSwordData getBlankData(){
            return new SummonSwordData(ItemStack.EMPTY);
        }
    }

    public record SummonSwordComponentData(UUID player, UUID summonId){
        public static final Codec<SummonSwordComponentData> CODEC = RecordCodecBuilder.create(instance ->
            instance.group(
                UUIDUtil.AUTHLIB_CODEC.fieldOf("playerId").forGetter(SummonSwordComponentData::player),
                UUIDUtil.AUTHLIB_CODEC.fieldOf("summonId").forGetter(SummonSwordComponentData::summonId)
            ).apply(instance, SummonSwordComponentData::new)
        );

        public static final StreamCodec<? super RegistryFriendlyByteBuf, SummonSwordComponentData> PACKET_CODEC = StreamCodec.composite(
            UUIDUtil.STREAM_CODEC, SummonSwordComponentData::player,
            UUIDUtil.STREAM_CODEC, SummonSwordComponentData::summonId,
            SummonSwordComponentData::new
        );
    }
}
