package com.samsthenerd.monthofswords.items;

import java.util.List;
import java.util.Optional;
import java.util.function.UnaryOperator;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Style;
import net.minecraft.tags.EnchantmentTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.EnchantmentInstance;

public class EnchantSwordItem extends SwordtemberItem{

    private final RandomSource random = RandomSource.create();
    private final DataSlot seed = DataSlot.standalone();

    public EnchantSwordItem(Item.Properties itemSettings) {
        super(Tiers.DIAMOND, itemSettings.attributes(
                SwordItem.createAttributes(Tiers.DIAMOND, 3, -2.4f))
        );
    }

    @Override
    public UnaryOperator<Style> getSwordTooltipStyleModifier(){
        return (style) -> style.withColor(0xcb88f7);
    }

    @Override
    public boolean hurtEnemy(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        // remove enchants
        EnchantmentHelper.updateEnchantments(stack, components -> components.removeIf(enchantment -> !enchantment.is(EnchantmentTags.CURSE)));

        // generate some new enchants
        this.random.setSeed(this.seed.get() + attacker.position().hashCode());
        Optional<HolderSet.Named<Enchantment>> optional = attacker.level().registryAccess().registryOrThrow(Registries.ENCHANTMENT)
                .getTag(EnchantmentTags.IN_ENCHANTING_TABLE);
        if (!optional.isEmpty()) {
            List<EnchantmentInstance> list = EnchantmentHelper.selectEnchantment(this.random, stack, 30, optional.get().stream());
            for (EnchantmentInstance enchantmentinstance : list) {
                stack.enchant(enchantmentinstance.enchantment, enchantmentinstance.level);
            }
        }

        return super.hurtEnemy(stack, target, attacker);
    }
}
