package com.samsthenerd.monthofswords;

import com.google.common.base.Suppliers;
import com.samsthenerd.monthofswords.lucky.LuckyFunctions;
import com.samsthenerd.monthofswords.registry.*;
import com.samsthenerd.monthofswords.xplat.SwordsModXPlat;
import dev.architectury.event.EventResult;
import dev.architectury.event.events.common.EntityEvent;
import dev.architectury.registry.registries.RegistrarManager;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.GameRules.BooleanValue;
import net.minecraft.world.level.GameRules.Category;
import net.minecraft.world.level.GameRules.Key;

public final class SwordsMod {
    public static final String MOD_ID = "monthofswords";

    public static ResourceLocation id(String path){
        return ResourceLocation.fromNamespaceAndPath(MOD_ID, path);
    }

    public static final Supplier<RegistrarManager> MANAGER = Suppliers.memoize(() -> RegistrarManager.get(MOD_ID));

    public static final Logger LOGGER = LoggerFactory.getLogger(MOD_ID);

    public static SwordsModXPlat XPLAT_INSTANCE = null;

    public static void init() {
        SwordsModAttributes.init();
        SwordsModItems.register();
        SwordsModEntities.register();
        SwordsModNetworking.commonInit();
        SwordsModLoot.init();
        SwordsModStatusEffects.init();
        SwordsModComponents.register();
        SwordsModDataLoaders.init();
        LuckyFunctions.register();
        SwordsModDataAttachments.init();

        EntityEvent.LIVING_HURT.register((LivingEntity entity, DamageSource source, float amount) -> {
            ItemStack victimStack = entity.getMainHandItem();
            if(entity instanceof Player player
                && player.isUsingItem()
                && victimStack.getItem().equals(SwordsModItems.DUELING_SWORD.get())
                && !source.is(DamageTypeTags.BYPASSES_SHIELD)
                && !player.getCooldowns().isOnCooldown(victimStack.getItem())
            ){
                player.getCooldowns().addCooldown(victimStack.getItem(), 15);
                victimStack.hurtAndBreak(1, entity, EquipmentSlot.MAINHAND);
            }
            return EventResult.pass();
        });
    }

    public static Key<BooleanValue> DESTRUCTIVE_ADVENTURE_SWORDS = GameRules.register(
      "monthOfSwordsDestructiveAdventureMode", Category.PLAYER, BooleanValue.create(false)
    );

    public static Key<BooleanValue> SUPER_SUPER_SAFE_SWORDS = GameRules.register(
      "monthOfSwordsNoDestructionEVER", Category.PLAYER, BooleanValue.create(false)
    );

    public static boolean canBeDestructive(Player player, @Nullable BlockPos pos){
        if(player.level().getGameRules().getBoolean(SUPER_SUPER_SAFE_SWORDS)) return false;
        if(player.level().getGameRules().getBoolean(DESTRUCTIVE_ADVENTURE_SWORDS)) return true;
        if(pos != null && !player.mayInteract(player.level(), pos)) return false;
        return player.mayBuild();
    }
}
