/*
 * Decompiled with CFR 0.152.
 */
package com.samsthenerd.monthofswords.items;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.samsthenerd.monthofswords.items.ClassyToolMaterial;
import com.samsthenerd.monthofswords.items.SwordActionHaverServer;
import com.samsthenerd.monthofswords.items.SwordtemberItem;
import com.samsthenerd.monthofswords.registry.SwordsModComponents;
import com.samsthenerd.monthofswords.registry.SwordsModDataAttachments;
import com.samsthenerd.monthofswords.registry.SwordsModItems;
import com.samsthenerd.monthofswords.xplat.SwordsModXPlat;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.UUIDUtil;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;

public class SummonableSwordItem
extends SwordtemberItem
implements SwordActionHaverServer {
    public static final Tier SUMMONABLE_MATERIAL = new ClassyToolMaterial(100, 5.0f, 3.0f, (TagKey<Block>)BlockTags.INCORRECT_FOR_DIAMOND_TOOL, 15, () -> Ingredient.EMPTY);

    public SummonableSwordItem(Item.Properties itemSettings) {
        super(SUMMONABLE_MATERIAL, itemSettings.attributes(SwordItem.createAttributes((Tier)SUMMONABLE_MATERIAL, (int)3, (float)-2.4f)));
    }

    public void inventoryTick(ItemStack stack, Level world, Entity entity, int slot, boolean selected) {
        if (world.isClientSide()) {
            return;
        }
        SummonSwordComponentData swordSscd = (SummonSwordComponentData)stack.get(SwordsModComponents.SUMMON_SWORD_DATA);
        if (swordSscd == null) {
            return;
        }
        if (!swordSscd.player.equals(entity.getUUID())) {
            stack.shrink(1);
            return;
        }
        Optional<SummonSwordData> optSD = SwordsModXPlat.getInstance().getEntityTarget(entity).getAttached(SwordsModDataAttachments.SUMMON_SWORD_DATA_ATTACHMENT_TYPE);
        if (optSD.isEmpty()) {
            return;
        }
        SummonSwordComponentData attachSscd = (SummonSwordComponentData)optSD.get().stack().get(SwordsModComponents.SUMMON_SWORD_DATA);
        if (attachSscd == null) {
            return;
        }
        if (!attachSscd.summonId().equals(swordSscd.summonId)) {
            stack.shrink(1);
            return;
        }
    }

    public static void trySummonSword(Player player) {
        ItemStack mainStack = player.getItemInHand(InteractionHand.MAIN_HAND);
        if (!mainStack.isEmpty()) {
            return;
        }
        Optional<SummonSwordData> optSD = SwordsModXPlat.getInstance().getEntityTarget((Entity)player).modifyAttached(SwordsModDataAttachments.SUMMON_SWORD_DATA_ATTACHMENT_TYPE, optSDOld -> optSDOld.map(SummonSwordData::withFreshUuid));
        if (optSD.isEmpty()) {
            return;
        }
        ItemStack stack = optSD.get().stack();
        if (stack.isEmpty()) {
            return;
        }
        player.setItemInHand(InteractionHand.MAIN_HAND, stack.copy());
    }

    @Override
    public boolean doSwordAction(Player player, ItemStack swordStack) {
        SwordsModXPlat.getInstance().getEntityTarget((Entity)player).modifyAttached(SwordsModDataAttachments.SUMMON_SWORD_DATA_ATTACHMENT_TYPE, optSD -> optSD.map(sd -> sd.saveSwordInfo(swordStack)));
        swordStack.setCount(0);
        return true;
    }

    public record SummonSwordComponentData(UUID player, UUID summonId) {
        public static final Codec<SummonSwordComponentData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)UUIDUtil.AUTHLIB_CODEC.fieldOf("playerId").forGetter(SummonSwordComponentData::player), (App)UUIDUtil.AUTHLIB_CODEC.fieldOf("summonId").forGetter(SummonSwordComponentData::summonId)).apply((Applicative)instance, SummonSwordComponentData::new));
        public static final StreamCodec<? super RegistryFriendlyByteBuf, SummonSwordComponentData> PACKET_CODEC = StreamCodec.composite((StreamCodec)UUIDUtil.STREAM_CODEC, SummonSwordComponentData::player, (StreamCodec)UUIDUtil.STREAM_CODEC, SummonSwordComponentData::summonId, SummonSwordComponentData::new);
    }

    public record SummonSwordData(ItemStack stack) {
        public static SummonSwordData getFreshData(Player player) {
            UUID summonId = UUID.randomUUID();
            ItemStack sword = new ItemStack((ItemLike)SwordsModItems.SUMMONED_SWORD.get());
            sword.set(SwordsModComponents.SUMMON_SWORD_DATA, (Object)new SummonSwordComponentData(player.getUUID(), summonId));
            return new SummonSwordData(sword);
        }

        public SummonSwordData withFreshUuid() {
            SummonSwordComponentData sscd = (SummonSwordComponentData)this.stack.get(SwordsModComponents.SUMMON_SWORD_DATA);
            if (sscd == null) {
                return this;
            }
            SummonSwordComponentData sscdNew = new SummonSwordComponentData(sscd.player, UUID.randomUUID());
            ItemStack newStack = this.stack.copy();
            newStack.set(SwordsModComponents.SUMMON_SWORD_DATA, (Object)sscdNew);
            return new SummonSwordData(newStack);
        }

        public SummonSwordData saveSwordInfo(ItemStack newSword) {
            ItemStack newerSword = newSword.copy();
            newerSword.setDamageValue(0);
            newerSword.set(DataComponents.REPAIR_COST, (Object)0);
            SummonSwordComponentData sscd = (SummonSwordComponentData)this.stack.get(SwordsModComponents.SUMMON_SWORD_DATA);
            newerSword.set(SwordsModComponents.SUMMON_SWORD_DATA, (Object)sscd);
            return new SummonSwordData(newerSword);
        }

        public static SummonSwordData getBlankData() {
            return new SummonSwordData(ItemStack.EMPTY);
        }
    }
}

