package com.samsthenerd.monthofswords.screen;

import com.samsthenerd.monthofswords.SwordsMod;
import com.samsthenerd.monthofswords.mixins.MixinClientAdvancementManagerAccessor;
import com.samsthenerd.monthofswords.registry.SwordsModComponents;
import com.samsthenerd.monthofswords.registry.SwordsModItems;
import com.samsthenerd.monthofswords.tooltips.RecipeTooltipData;
import com.samsthenerd.monthofswords.utils.Description;
import com.samsthenerd.monthofswords.utils.Description.AcquisitionDesc.CraftingDesc;
import com.samsthenerd.monthofswords.utils.Description.DescriptionItemComponent;
import com.samsthenerd.monthofswords.utils.ItemDescriptions;
import org.lwjgl.glfw.GLFW;

import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.AdvancementProgress;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.ClientAdvancements;
import net.minecraft.core.component.TypedDataComponent;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;

public class SwordCalendarScreen extends Screen {
    public SwordCalendarScreen() {
        super(Component.literal("Sword Calendar"));
    }

    public static final ResourceLocation CALENDAR_BACK = SwordsMod.id("textures/gui/calendar_back.png");
    public static final ResourceLocation CALENDAR_STICKERS = SwordsMod.id("textures/gui/calendar_stickers.png");

    public static final int CALENDAR_WIDTH = 256;
    public static final int CALENDAR_HEIGHT = 208;

    public boolean hintMode = true;

    @Override
    public void render(GuiGraphics context, int mouseX, int mouseY, float delta) {
        int guiX = (context.guiWidth()-CALENDAR_WIDTH)/2;
        int guiY = (context.guiHeight()-CALENDAR_HEIGHT)/2;
        super.render(context, mouseX, mouseY, delta);
        int hoverSwordIdx = getSwordAtCoordinate(mouseX - guiX, mouseY - guiY);
        context.blit(CALENDAR_BACK, guiX, guiY, 100, 0, 0, CALENDAR_WIDTH, CALENDAR_HEIGHT, 512, 512);
        var advHandler = Minecraft.getInstance().getConnection().getAdvancements();
        var advProgs = ((MixinClientAdvancementManagerAccessor)(Object) advHandler).getAdvancementProgresses();
        for(int i = 0; i < SwordsModItems.ALL_SWORDS.size(); i++){

//            if(hoverSwordIdx != i) continue;
            ResourceLocation swordId = SwordsModItems.ALL_SWORDS.get(i);
            AdvancementHolder advEntry = advHandler.get(swordId.withPrefix("acquire_"));
            if(advEntry == null) continue;
            var advProg = advProgs.get(advEntry);
            if(advProg == null || !advProg.isDone()) continue;
            Item swordItem = BuiltInRegistries.ITEM.get(swordId);
            var swordPos = getSwordPosition(i);
            int swordX = swordPos.getA()  + guiX;
            int swordY = swordPos.getB() + guiY;
            context.blit(CALENDAR_STICKERS, swordX, swordY, 101, swordPos.getA(), swordPos.getB(),
                32, 32, 512, 512);
            context.renderItem(swordItem.getDefaultInstance(), swordX+8, swordY+8);
        }
        if(hoverSwordIdx != -1){
            ResourceLocation swordId = SwordsModItems.ALL_SWORDS.get(hoverSwordIdx);
            Item swordItem = BuiltInRegistries.ITEM.get(swordId);
            ItemStack swordStack = swordItem.getDefaultInstance();
            if(hintMode){
                for(var comp : swordStack.getComponents()){
                    swordStack.remove(comp.type());
                }
            }
            Optional<RecipeTooltipData> optRecData = Optional.empty();
            var recTTOpt = ItemDescriptions.getItemDescription(swordItem)
                .map(Description::acqDescs)
                .stream()
                .flatMap(Collection::stream)
                .flatMap(ad -> ((Optional<CraftingDesc>)(ad instanceof CraftingDesc cd ? Optional.of(cd) : Optional.empty())).stream())
                .findFirst()
                .flatMap(craftDesc -> Minecraft.getInstance().level.getRecipeManager().byKey(craftDesc.recId()))
                .map(RecipeHolder::value).map(RecipeTooltipData::new);

            swordStack.set(SwordsModComponents.ITEM_DESCRIPTION_DATA, new DescriptionItemComponent(hintMode, recTTOpt, false));
            context.renderTooltip(Minecraft.getInstance().font, swordStack, mouseX, mouseY);
        }
    }

    @Override
    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if(keyCode == GLFW.GLFW_KEY_E){
            this.onClose();
            return true;
        }
        if(keyCode == GLFW.GLFW_KEY_H){
            hintMode = !hintMode;
            return true;
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    public int getSwordAtCoordinate(int x, int y){
        if(x < 16 || y < 12) return -1;
        int ix = (x - 16) / 32;
        int iy = (y - 12) / 32;
        int mx = (x-16) % 32;
        int my = (y-12) % 32;
        if( mx < 2 || mx > 29 || my < 2 || my > 29) return -1;
        if(ix > 6 || ix < 0 || iy > 4 || iy < 0) return -1;
        int idx = iy * 7 + ix;
        if(idx == 29) return -1;
        if(idx == 34) idx = 29;
        if(idx > 29) return -1;
        return idx;
    }

    public static Tuple<Integer, Integer> getSwordPosition(int i){
        int idx = i;
        if(i == 29) idx = 34;
        int x = idx % 7;
        int y = idx / 7;
        int xPx = (x * 32) + 16;
        int yPx = (y * 32) + 12;
        return new Tuple<>(xPx, yPx);
    }

    @Override
    public boolean isPauseScreen() {
        return false;
    }
}
