package com.samsthenerd.monthofswords.render;

import com.samsthenerd.monthofswords.render.FakeGhostPlayerManager.GhostlyPlayerEntity;
import com.samsthenerd.monthofswords.utils.ColorUtils;
import java.util.Optional;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor.ARGB32;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;

public interface GhostlyProvider {

    static Optional<GhostlyProvider> getGhostlyProvider(LivingEntity livEnt){
        if(livEnt instanceof GhostlyPlayerEntity){
            return Optional.of((HueGhostlyProvider)((hd, v, t) -> ((float)(0.47f + 0.1f * hd))));
        }
//        else if(livEnt.hasStatusEffect(SwordsModStatusEffects.getEffect(SwordsModStatusEffects.DISPLACED))){
//            return Optional.of((HueGhostlyProvider)((hd, v, t) -> ((float)(0.05f + 0.1f * hd))));
//        }
        return Optional.empty();
    }

    int getGhostlyColor(int red, int green, int blue, int alpha, Vec3 lastVec, float time);

    default RenderType getGhostlyRenderLayer(RenderType originalLayer, LivingEntity entity,
                                              ResourceLocation originalTextureId, boolean showBody, boolean translucent, boolean showOutline){
        ResourceLocation ghostlyId = GhostifyTexture.getGhostifiedTexture(originalTextureId).orElse(originalTextureId);
        return RenderType.itemEntityTranslucentCull(ghostlyId);
    }

    default int getLightmapCoords(int u, int v, Vec3 lastVec, float time){
        return LightTexture.FULL_BRIGHT;
    }

    interface HueGhostlyProvider extends GhostlyProvider{

        float getGhostlyHue(double hd, Vec3 lastVec, float time);

        @Override
        default int getGhostlyColor(int red, int green, int blue, int alpha, Vec3 lastVec, float time){
            double t = Mth.positiveModulo(time, 4f);
            t = t < 2 ? t / 4 : 1-t /4;
            Vec3 d = new Vec3(1,3,1).normalize();
            double hd = Mth.positiveModulo(lastVec.dot(d) - time, 1.0);
            float hue = getGhostlyHue(hd, lastVec, time);
            int argb = ColorUtils.HSBtoRGB(hue, 1f, 1f);
            return ARGB32.color(128, argb);
        }
    }
}
