package com.samsthenerd.monthofswords.render;

import com.mojang.authlib.GameProfile;
import com.samsthenerd.monthofswords.mixins.MixinLivingEntAccessor;
import com.samsthenerd.monthofswords.utils.LivingEntDuck;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.RemotePlayer;
import net.minecraft.client.resources.PlayerSkin;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.PlayerModelPart;
import net.minecraft.world.phys.Vec3;

public class FakeGhostPlayerManager {

    private static final Map<GameProfile, GhostlyPlayerEntity> GHOST_PLAYERS = new HashMap<>();

    public static void makeFakePlayer(GameProfile profile, Player player){
        ClientLevel cWorld =  Minecraft.getInstance().level;
        var ghost = new GhostlyPlayerEntity(cWorld, Minecraft.getInstance().getGameProfile(), player);
        ghost.setUUID(UUID.randomUUID());
        ghost.noPhysics = true;
        cWorld.addEntity(ghost);
        GHOST_PLAYERS.put(profile, ghost);
    }

    public static void removePlayer(GameProfile profile){
        var ghost = GHOST_PLAYERS.get(profile);
        if(ghost == null) return;
        ghost.discard();
        GHOST_PLAYERS.remove(profile);
    }

    public static Optional<GhostlyPlayerEntity> getGhostPlayer(GameProfile profile){
        return Optional.ofNullable(GHOST_PLAYERS.get(profile));
    }

    public static void setPlayerPosition(GameProfile profile, Vec3 pos){
        getGhostPlayer(profile).ifPresent(ghost -> ghost.setPos(pos));
    }

    public static void makeFakePlayer(){
        makeFakePlayer(Minecraft.getInstance().getGameProfile(), Minecraft.getInstance().player);
    }

    public static void removePlayer(){
        removePlayer(Minecraft.getInstance().getGameProfile());
    }

    public static Optional<GhostlyPlayerEntity> getGhostPlayer(){
        return getGhostPlayer(Minecraft.getInstance().getGameProfile());
    }

    public static void setPlayerPosition(Vec3 pos){
        setPlayerPosition(Minecraft.getInstance().getGameProfile(), pos);
    }

    public static class GhostlyPlayerEntity extends RemotePlayer{

        public Player playerBody;

        public GhostlyPlayerEntity(ClientLevel clientWorld, GameProfile gameProfile, Player playerBody){
            super(clientWorld, gameProfile);
            this.playerBody = playerBody;
        }

        @Override
        public boolean canCollideWith(Entity other) {
            return false;
        }

//        @Override
//        public boolean collidesWithStateAtPos(BlockPos pos, BlockState state) {
//            return super.collidesWithStateAtPos(pos, state);
//        }
//
//        @Override
//        protected void checkBlockCollision() {
//            super.checkBlockCollision();
//        }

        @Override
        public PlayerSkin getSkin() {
            return Minecraft.getInstance().getSkinManager().getInsecureSkin(getGameProfile());
        }

        @Override
        public boolean isModelPartShown(PlayerModelPart modelPart) {
            return modelPart != PlayerModelPart.CAPE; // cape looks weird. idk maybe make it configurable or something
        }

        @Override
        public boolean shouldShowName() {
            return false;
        }

        @Override
        public boolean isCurrentlyGlowing() {
            return !playerBody.hasLineOfSight(this);
//            return super.isGlowing();
        }

        @Override
        public void tick() {
            if(((LivingEntDuck)playerBody).getLastEchoUsage() == -1){
                this.discard();
                removePlayer(getGameProfile());
                return;
            }
            level().addParticle(
                ParticleTypes.TRIAL_SPAWNER_DETECTED_PLAYER_OMINOUS,
                getX()+getRandom().nextDouble()-0.5,
                getY()+getRandom().nextDouble(),
                getZ()+getRandom().nextDouble()-0.5,
                0, 0, 0
            );
            super.tick();
            if(this.isVisuallySwimming()){
                ((MixinLivingEntAccessor)this).mos$setLeaningPitch(1);
                ((MixinLivingEntAccessor)this).mos$setLastLeaningPitch(1);
            } else {
                ((MixinLivingEntAccessor)this).mos$setLeaningPitch(0);
                ((MixinLivingEntAccessor)this).mos$setLastLeaningPitch(0);
            }
        }

        @Override
        public void updatePlayerPose() {
//            SwordsMod.LOGGER.info("boop");
            if (this.canPlayerFitWithinBlocksAndEntitiesWhen(Pose.SWIMMING)) {
                Pose entityPose = this.isFallFlying() ? Pose.FALL_FLYING : (this.isSleeping() ? Pose.SLEEPING : (this.isSwimming() ? Pose.SWIMMING : (this.isAutoSpinAttack() ? Pose.SPIN_ATTACK : (this.isShiftKeyDown() && !this.getAbilities().flying ? Pose.CROUCHING : Pose.STANDING))));
                Pose entityPose2 = this.isSpectator() || this.isPassenger() || this.canPlayerFitWithinBlocksAndEntitiesWhen(entityPose) ? entityPose : (this.canPlayerFitWithinBlocksAndEntitiesWhen(Pose.CROUCHING) ? Pose.CROUCHING : Pose.SWIMMING);
                this.setPose(entityPose2);
            }
            if(this.canPlayerFitWithinBlocksAndEntitiesWhen(playerBody.getPose())){
                this.setPose(playerBody.getPose());
            }
        }

        @Override
        public boolean canPlayerFitWithinBlocksAndEntitiesWhen(Pose pose) {
            return super.canPlayerFitWithinBlocksAndEntitiesWhen(pose);
        }

        @Override
        protected void pushEntities() {
//            super.tickCramming();
        }

        @Override
        public void moveTowardsClosestSpace(double x, double y, double z) {
            super.moveTowardsClosestSpace(x, y, z);
        }
    }

}
