package com.samsthenerd.monthofswords.items;

import com.samsthenerd.monthofswords.items.SummonableSwordItem.SummonSwordData;
import com.samsthenerd.monthofswords.registry.SwordsModDataAttachments;
import com.samsthenerd.monthofswords.xplat.SwordsModXPlat;
import java.util.Optional;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class SummonFruitItem extends DescriptableItem {

    public final boolean summonOrBanish;

    public SummonFruitItem(Properties settings, boolean summonOrBanish) {
        super(settings);
        this.summonOrBanish = summonOrBanish;
    }

    @Override
    public ItemStack finishUsingItem(ItemStack stack, Level world, LivingEntity user) {
        if(user instanceof ServerPlayer sPlayer){
            SwordsModXPlat.getInstance().getEntityTarget(user).modifyAttached(SwordsModDataAttachments.SUMMON_SWORD_DATA_ATTACHMENT_TYPE,
                optSD -> {
                    if(optSD.isEmpty() && summonOrBanish){
                        return Optional.of(SummonSwordData.getFreshData(sPlayer));
                    } else if (!summonOrBanish){
                        // reset it?
                        return Optional.of(SummonSwordData.getFreshData(sPlayer));
                    }
                    return optSD;
                });
        }
        return super.finishUsingItem(stack, world, user);
    }
}
