package com.samsthenerd.monthofswords.items;

import com.samsthenerd.monthofswords.SwordsMod;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.crafting.Ingredient;

public class MechanicalSwordItem extends SwordtemberItem {

    public static final TagKey<Item> BRONZE_TAG = TagKey.create(Registries.ITEM, ResourceLocation.fromNamespaceAndPath("c", "ingots/bronze"));

    public static final Tier BRONZEISH_MATERIAL = new ClassyToolMaterial(500, 5f, 2.5f,
        BlockTags.INCORRECT_FOR_IRON_TOOL, 10,
        hasBronze() ? () -> Ingredient.of(BRONZE_TAG) : () -> Ingredient.of(Items.GOLD_INGOT));

    public static boolean hasBronze(){
        return BuiltInRegistries.ITEM.getTag(BRONZE_TAG).map(l -> l.size() > 0).orElse(false);
    }

    public MechanicalSwordItem(Item.Properties itemSettings) {
        super(BRONZEISH_MATERIAL, itemSettings.attributes(
            SwordItem.createAttributes(BRONZEISH_MATERIAL, 3, -2f)
                .withModifierAdded(Attributes.BLOCK_INTERACTION_RANGE,
                    new AttributeModifier(SwordsMod.id("mechanical_reach_mod"), 2, AttributeModifier.Operation.ADD_VALUE),
                    EquipmentSlotGroup.MAINHAND)
                .withModifierAdded(Attributes.ENTITY_INTERACTION_RANGE,
                    new AttributeModifier(SwordsMod.id("mechanical_reach_mod"), 2, AttributeModifier.Operation.ADD_VALUE),
                    EquipmentSlotGroup.MAINHAND)
            )
        );
    }
}
