package com.samsthenerd.monthofswords.items;

import com.samsthenerd.monthofswords.entities.LeafAttackEntity;
import java.util.function.UnaryOperator;
import net.minecraft.network.chat.Style;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.phys.Vec3;

public class ForestSwordItem extends SwordtemberItem implements SwordLeftClickHaverServer{

    public ForestSwordItem(Item.Properties itemSettings) {
        super(Tiers.DIAMOND, itemSettings.attributes(
            SwordItem.createAttributes(Tiers.DIAMOND, 3, -2f))
        );
    }

    @Override
    public void doSwordLCAction(Player player, ItemStack swordStack) {
        if(player.getCooldowns().isOnCooldown(this)) return;
        var fireball = new LeafAttackEntity(player.level());
        player.level().playSound(null, player.blockPosition(), SoundEvents.CHERRY_LEAVES_PLACE,
            SoundSource.PLAYERS, 1.5f, player.getRandom().nextFloat() * 0.2f + .2f);
        player.level().playSound(null, player.blockPosition(), SoundEvents.BREEZE_LAND,
            SoundSource.PLAYERS, 1f, player.getRandom().nextFloat() * 0.1f + 0.7f);
        player.level().playSound(null, player.blockPosition(), SoundEvents.AMETHYST_BLOCK_CHIME,
            SoundSource.PLAYERS, 3f, player.getRandom().nextFloat() * 0.3f + 1.2f);
        fireball.setOwner(player);
        fireball.setDeltaMovement(player.getLookAngle().scale(3));
        Vec3 lookVec = player.getLookAngle();
        fireball.setPos(player.position().add(lookVec.x, 1.4, lookVec.z));
        player.level().addFreshEntity(fireball);
        player.getCooldowns().addCooldown(this, 15);
        swordStack.hurtAndBreak(1, player, EquipmentSlot.MAINHAND);
    }

    public UnaryOperator<Style> getSwordTooltipStyleModifier(){
        return (style) -> style.withColor(0xf7b9dc);
    }
}
